/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.formatting;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.Nullable;

public final class StringFormatter {
    private static final char MASKING_CHAR = '*';

    @Nullable
    public static String colorize(@Nullable String input) {
        return input != null && !input.isEmpty() ? ChatColor.translateAlternateColorCodes((char)'&', (String)input) : input;
    }

    @Nullable
    public static List<String> colorize(@Nullable List<String> input) {
        return input != null && !input.isEmpty() ? input.stream().map(StringFormatter::colorize).collect(Collectors.toList()) : input;
    }

    @Nullable
    public static String maskAccessKey(@Nullable String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        char[] chars = input.toCharArray();
        int length = chars.length;
        if (length > 8) {
            for (int i = 4; i < length - 4; ++i) {
                chars[i] = 42;
            }
        }
        return new String(chars);
    }

    @Nullable
    public static String format(@Nullable String input, Object ... args) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        if (args == null || args.length == 0) {
            return input;
        }
        String output = input;
        int length = args.length;
        for (int i = 0; i < length && i != length - 1; i += 2) {
            Object rawKey = args[i];
            if (rawKey == null) continue;
            String key = String.valueOf(rawKey);
            String value = String.valueOf(args[i + 1]);
            output = output.replace(key, value);
        }
        return output;
    }

    @Generated
    private StringFormatter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

