/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.object;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import ru.easydonate.easypayments.core.exception.StructureValidationException;
import ru.easydonate.easypayments.libs.easydonate4j.data.model.PrettyPrintable;
import ru.easydonate.easypayments.libs.gson.annotations.SerializedName;

public final class PurchasedProduct
implements PrettyPrintable {
    @SerializedName(value="id")
    private int id;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="commands")
    private List<String> commands;
    @SerializedName(value="raw_commands")
    private List<String> rawCommands;
    @SerializedName(value="cost")
    private double cost;
    @SerializedName(value="count")
    private int count;
    @SerializedName(value="issue_now")
    private boolean issueNow;

    public void validate() throws StructureValidationException {
        if (this.id <= 0) {
            throw new StructureValidationException(this, "'id' must be > 0, but it's %d", this.id);
        }
        if (this.name == null || this.name.isEmpty()) {
            throw new StructureValidationException(this, "'name' is required", new Object[0]);
        }
        if (this.commands == null || this.commands.isEmpty()) {
            throw new StructureValidationException(this, "no commands present", new Object[0]);
        }
        if (this.cost < 0.0) {
            throw new StructureValidationException(this, "'cost' must be >= 0, but it's %s", this.cost);
        }
        if (this.count <= 0) {
            throw new StructureValidationException(this, "'count' must be > 0, but it's %s", this.count);
        }
    }

    public List<String> getRawCommands() {
        return this.rawCommands != null ? this.rawCommands : this.commands;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PurchasedProduct product = (PurchasedProduct)o;
        return this.id == product.id && Double.compare(product.cost, this.cost) == 0 && this.count == product.count && Objects.equals(this.name, product.name) && Objects.equals(this.commands, product.commands) && Objects.equals(this.rawCommands, product.rawCommands);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.commands, this.rawCommands, this.cost, this.count, this.issueNow);
    }

    public String toString() {
        return "PurchasedProduct{id=" + this.id + ", name='" + this.name + '\'' + ", commands=" + this.commands + ", rawCommands=" + this.rawCommands + ", cost=" + this.cost + ", count=" + this.count + ", issueNow=" + this.issueNow + '}';
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<String> getCommands() {
        return this.commands;
    }

    @Generated
    public double getCost() {
        return this.cost;
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    @Generated
    public boolean isIssueNow() {
        return this.issueNow;
    }

    @Generated
    public PurchasedProduct() {
    }

    @Generated
    public PurchasedProduct(int id, String name, List<String> commands, List<String> rawCommands, double cost, int count, boolean issueNow) {
        this.id = id;
        this.name = name;
        this.commands = commands;
        this.rawCommands = rawCommands;
        this.cost = cost;
        this.count = count;
        this.issueNow = issueNow;
    }
}

