/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.easydonate4j.EventType;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventReportObject;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventUpdateReport;
import ru.easydonate.easypayments.core.easydonate4j.json.serialization.EventTypeAdapter;
import ru.easydonate.easypayments.core.easydonate4j.json.serialization.EventUpdateDeserializer;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.EventObject;
import ru.easydonate.easypayments.core.exception.StructureValidationException;
import ru.easydonate.easypayments.libs.easydonate4j.data.model.PrettyPrintable;
import ru.easydonate.easypayments.libs.gson.annotations.JsonAdapter;
import ru.easydonate.easypayments.libs.gson.annotations.SerializedName;

@JsonAdapter(value=EventUpdateDeserializer.class)
public final class EventUpdate<E extends EventObject>
implements PrettyPrintable {
    @JsonAdapter(value=EventTypeAdapter.class)
    @SerializedName(value="type")
    private EventType eventType;
    @SerializedName(value="objects")
    private List<E> eventObjects;

    @NotNull
    public <R extends EventReportObject> EventUpdateReport<R> createReport() {
        return new EventUpdateReport(this.eventType);
    }

    public void validate() throws StructureValidationException {
        if (this.hasUnknownType()) {
            throw new StructureValidationException(this, "no known event type present", new Object[0]);
        }
        if (!this.hasEventObjects()) {
            throw new StructureValidationException(this, "no event objects present", new Object[0]);
        }
    }

    public boolean hasUnknownType() {
        return this.eventType == null || this.eventType == EventType.UNKNOWN;
    }

    public boolean hasEventObjects() {
        return this.eventObjects != null && !this.eventObjects.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventUpdate that = (EventUpdate)o;
        return this.eventType == that.eventType && Objects.equals(this.eventObjects, that.eventObjects);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventType, this.eventObjects});
    }

    @NotNull
    public String toString() {
        return "EventUpdate{eventType=" + (Object)((Object)this.eventType) + ", eventObjects=" + this.eventObjects + '}';
    }

    @Generated
    public EventType getEventType() {
        return this.eventType;
    }

    @Generated
    public List<E> getEventObjects() {
        return this.eventObjects;
    }

    @Generated
    public EventUpdate() {
    }

    @Generated
    public EventUpdate(EventType eventType, List<E> eventObjects) {
        this.eventType = eventType;
        this.eventObjects = eventObjects;
    }
}

