/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.easydonate4j.json.serialization.LocalDateTimeAdapter;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.plugin.PluginEvent;
import ru.easydonate.easypayments.core.exception.StructureValidationException;
import ru.easydonate.easypayments.libs.easydonate4j.data.model.PrettyPrintable;
import ru.easydonate.easypayments.libs.gson.annotations.JsonAdapter;
import ru.easydonate.easypayments.libs.gson.annotations.SerializedName;

public abstract class EventObject
implements PrettyPrintable {
    @SerializedName(value="customer")
    protected String customer;
    @JsonAdapter(value=LocalDateTimeAdapter.class)
    @SerializedName(value="created_at")
    protected LocalDateTime createdAt;
    @SerializedName(value="plugins")
    protected List<PluginEvent> pluginEvents;

    public boolean hasPluginEvents() {
        return this.pluginEvents != null && !this.pluginEvents.isEmpty();
    }

    public void validate() throws StructureValidationException {
        if (this.customer == null) {
            this.validationFail("'customer' = null", new Object[0]);
        }
        if (this.customer.isEmpty()) {
            this.validationFail("'customer' is empty", new Object[0]);
        }
    }

    protected void validationFail(@NotNull String message, Object ... args) throws StructureValidationException {
        throw new StructureValidationException(this, message, args);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventObject that = (EventObject)o;
        return Objects.equals(this.customer, that.customer) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.pluginEvents, that.pluginEvents);
    }

    public int hashCode() {
        return Objects.hash(this.customer, this.createdAt, this.pluginEvents);
    }

    @NotNull
    public String toString() {
        return "EventObject{customer='" + this.customer + '\'' + ", createdAt=" + this.createdAt + ", pluginEvents=" + this.pluginEvents + '}';
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public List<PluginEvent> getPluginEvents() {
        return this.pluginEvents;
    }
}

