/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.easydonate4j.longpoll.client;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.EventUpdates;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.response.GetUpdatesListResponse;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.exception.ApiResponseFailureException;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.ApiResponse;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.ErrorResponse;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.ResponseContentDeserializer;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpRequestException;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpResponseException;
import ru.easydonate.easypayments.libs.easydonate4j.http.Headers;
import ru.easydonate.easypayments.libs.easydonate4j.http.client.HttpClient;
import ru.easydonate.easypayments.libs.easydonate4j.http.client.jdk.legacy.JDKLegacyHttpClientService;
import ru.easydonate.easypayments.libs.easydonate4j.http.request.EasyHttpRequest;
import ru.easydonate.easypayments.libs.easydonate4j.http.response.EasyHttpResponse;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.GsonSerializationService;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.implementation.registry.JsonModelsGroup;
import ru.easydonate.easypayments.libs.easydonate4j.module.ModuleRegistrator;

public final class LongPollClient {
    public static final String API_ENDPOINT = "https://ep.easydonate.ru";
    public static final String HEADER_SHOP_KEY = "X-Shop-Key";
    public static final String HEADER_SERVER_ID = "X-Server-Id";
    public static final String HEADER_RUNTIME_ID = "X-Runtime-Id";
    public static final long READ_TIMEOUT = 60000L;
    private static final String CURRENT_RUNTIME_ID = LongPollClient.resolveCurrentRuntimeId();
    private final Headers defaultHeaders;
    private final HttpClient httpClient;
    private final ExecutorService asyncExecutorService;

    private LongPollClient(@NotNull String accessKey, int serverId, @NotNull String userAgent) {
        this.defaultHeaders = new Headers().set(HEADER_SHOP_KEY, accessKey).set(HEADER_SERVER_ID, serverId).set(HEADER_RUNTIME_ID, CURRENT_RUNTIME_ID);
        this.httpClient = ModuleRegistrator.httpClientService().buildClient().setResponseTimeout(60000L).setReadTimeout(60000L).setUserAgent(userAgent).create();
        this.asyncExecutorService = Executors.newCachedThreadPool();
    }

    @NotNull
    public static LongPollClient create(@NotNull String accessKey, int serverId, @NotNull String userAgent) {
        GsonSerializationService.registerIfNotRegisteredYet();
        JDKLegacyHttpClientService.registerIfNotRegisteredYet();
        ModuleRegistrator.jsonSerializationService().registerImplementationAliasesGroup(JsonModelsGroup.API_V3_MODELS);
        return new LongPollClient(accessKey, serverId, userAgent);
    }

    @NotNull
    public Headers getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public void shutdown() {
        if (this.asyncExecutorService != null) {
            this.asyncExecutorService.shutdown();
        }
    }

    @NotNull
    public CompletableFuture<EventUpdates> getUpdatesList() {
        return this.requestAsync(EasyHttpRequest.builder(this.httpClient, HttpClient.Method.GET), GetUpdatesListResponse.class);
    }

    @NotNull
    public EventUpdates getUpdatesListSync() throws HttpRequestException, HttpResponseException {
        try {
            return (EventUpdates)this.request(EasyHttpRequest.builder(this.httpClient, HttpClient.Method.GET), GetUpdatesListResponse.class);
        }
        catch (ApiResponseFailureException responseFailureException) {
            ErrorResponse errorResponse = responseFailureException.getErrorResponse();
            if (errorResponse.getErrorCode() == 0) {
                return EventUpdates.EMPTY;
            }
            throw responseFailureException;
        }
    }

    @NotNull
    public EasyHttpResponse makeCustomRequest(@NotNull HttpClient.Method method, @NotNull Consumer<EasyHttpRequest.Builder> builderPatcher) throws HttpRequestException {
        EasyHttpRequest.Builder builder = EasyHttpRequest.builder(this.httpClient, method).setApiEndpoint(API_ENDPOINT).setHeaders(this.defaultHeaders);
        builderPatcher.accept(builder);
        EasyHttpRequest request = builder.build();
        return request.execute();
    }

    @NotNull
    private <R extends ApiResponse<T>, T> CompletableFuture<T> requestAsync(@NotNull EasyHttpRequest.Builder builder, @NotNull Class<R> responseObjectType) {
        CompletableFuture future = new CompletableFuture();
        CompletableFuture.runAsync(() -> {
            try {
                Object result = this.request(builder, responseObjectType);
                future.complete(result);
            }
            catch (HttpRequestException | HttpResponseException ex) {
                future.completeExceptionally(ex);
            }
        }, this.asyncExecutorService);
        return future;
    }

    @NotNull
    private <R extends ApiResponse<T>, T> T request(@NotNull EasyHttpRequest.Builder builder, @NotNull Class<R> responseObjectType) throws HttpRequestException, HttpResponseException {
        EasyHttpRequest request = builder.setApiEndpoint(API_ENDPOINT).setHeaders(this.defaultHeaders).build();
        EasyHttpResponse response = request.execute();
        return ResponseContentDeserializer.deserializeResponseContent(responseObjectType, response);
    }

    private static String resolveCurrentRuntimeId() {
        String runtimeId = System.getProperty("easypayments.runtimeId");
        if (runtimeId == null) {
            runtimeId = UUID.randomUUID().toString();
            System.setProperty("easypayments.runtimeId", runtimeId);
        }
        return runtimeId;
    }
}

