/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.easydonate4j.json.serialization;

import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.libs.gson.JsonDeserializationContext;
import ru.easydonate.easypayments.libs.gson.JsonDeserializer;
import ru.easydonate.easypayments.libs.gson.JsonElement;
import ru.easydonate.easypayments.libs.gson.JsonParseException;
import ru.easydonate.easypayments.libs.gson.JsonSerializationContext;
import ru.easydonate.easypayments.libs.gson.JsonSerializer;

public final class LocalDateTimeAdapter
implements JsonSerializer<LocalDateTime>,
JsonDeserializer<LocalDateTime> {
    private static final LocalDateTimeAdapter SINGLETON = new LocalDateTimeAdapter();
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    @NotNull
    public static LocalDateTimeAdapter getSingleton() {
        return SINGLETON;
    }

    @Override
    @Nullable
    public LocalDateTime deserialize(@NotNull JsonElement json, @NotNull Type type, @NotNull JsonDeserializationContext context) throws JsonParseException {
        String asString = json.getAsString();
        if (asString == null || asString.isEmpty()) {
            return null;
        }
        TemporalAccessor accessor = DATE_TIME_FORMAT.parse(asString);
        return LocalDateTime.from(accessor);
    }

    @Override
    @NotNull
    public JsonElement serialize(@Nullable LocalDateTime localDateTime, @NotNull Type type, @NotNull JsonSerializationContext context) {
        return context.serialize(localDateTime != null ? DATE_TIME_FORMAT.format(localDateTime) : null);
    }

    @Generated
    private LocalDateTimeAdapter() {
    }
}

