/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.easydonate4j.extension.data.model.object;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventReportObject;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.object.CommandReport;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.object.CommandReporting;
import ru.easydonate.easypayments.libs.gson.annotations.SerializedName;

public final class NewPaymentReport
extends EventReportObject
implements CommandReporting {
    @SerializedName(value="payment_id")
    private final int paymentId;
    @SerializedName(value="in_cart")
    private final boolean addedToCart;
    @SerializedName(value="customer")
    private final String customer;
    @SerializedName(value="commands")
    private List<CommandReport> commandReports;

    public NewPaymentReport(int paymentId, boolean addedToCart, String customer) {
        this.paymentId = paymentId;
        this.addedToCart = addedToCart;
        this.customer = customer;
    }

    public static NewPaymentReport createCartClearReport(int paymentId, String customer) {
        NewPaymentReport report = new NewPaymentReport(paymentId, false, customer);
        report.addCommandReport("[EasyPayments] This payment was removed from the cart!", "[EasyPayments] Reason: an operator used '/cart clear'");
        return report;
    }

    @Override
    public synchronized void addCommandReport(@NotNull CommandReport commandReport) {
        if (this.commandReports == null) {
            this.commandReports = new ArrayList<CommandReport>();
        }
        this.commandReports.add(commandReport);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NewPaymentReport report = (NewPaymentReport)o;
        return this.paymentId == report.paymentId && this.addedToCart == report.addedToCart && Objects.equals(this.customer, report.customer) && Objects.equals(this.commandReports, report.commandReports);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.paymentId, this.addedToCart, this.customer, this.commandReports);
    }

    @Override
    @NotNull
    public String toString() {
        return "NewPaymentReport{pluginEventReports=" + this.pluginEventReports + ", paymentId=" + this.paymentId + ", addedToCart=" + this.addedToCart + ", customer=" + this.customer + ", commandReports=" + this.commandReports + '}';
    }

    @Generated
    public int getPaymentId() {
        return this.paymentId;
    }

    @Generated
    public boolean isAddedToCart() {
        return this.addedToCart;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Override
    @Generated
    public List<CommandReport> getCommandReports() {
        return this.commandReports;
    }

    @Generated
    public NewPaymentReport(int paymentId, boolean addedToCart, String customer, List<CommandReport> commandReports) {
        this.paymentId = paymentId;
        this.addedToCart = addedToCart;
        this.customer = customer;
        this.commandReports = commandReports;
    }
}

