/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.dependency;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.dependency.DependencyLoader;

public final class PluginDependencyLoader
implements DependencyLoader {
    private static final String ADD_URL_METHOD_NAME = "addURL";
    private static final String URL_CLASS_PATH_FIELD_NAME = "ucp";
    private final URLClassLoader pluginClassLoader;

    public static DependencyLoader forPlugin(@NotNull Plugin plugin) {
        PluginDependencyLoader dependencyLoader = null;
        try {
            dependencyLoader = new PluginDependencyLoader(plugin);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return dependencyLoader;
    }

    private PluginDependencyLoader(@NotNull Plugin plugin) {
        ClassLoader pluginClassLoader = plugin.getClass().getClassLoader();
        if (!(pluginClassLoader instanceof URLClassLoader)) {
            throw new IllegalArgumentException("Plugin class loader is not instance of URLClassLoader");
        }
        this.pluginClassLoader = (URLClassLoader)pluginClassLoader;
    }

    @Override
    public boolean load(@NotNull Path dependencyPath) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, MalformedURLException {
        Method addUrlMethod = this.getAddUrlMethod();
        if (addUrlMethod == null) {
            return false;
        }
        URL url = dependencyPath.toUri().toURL();
        addUrlMethod.invoke((Object)this.pluginClassLoader, url);
        return true;
    }

    private Method getAddUrlMethod() {
        Method addUrlMethod = null;
        try {
            addUrlMethod = URLClassLoader.class.getDeclaredMethod(ADD_URL_METHOD_NAME, URL.class);
            addUrlMethod.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return addUrlMethod;
    }
}

