/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.command.shopcart;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.command.CommandExecutor;
import ru.easydonate.easypayments.command.annotation.Arguments;
import ru.easydonate.easypayments.command.annotation.Command;
import ru.easydonate.easypayments.command.annotation.MinimalArgsCount;
import ru.easydonate.easypayments.command.annotation.Permission;
import ru.easydonate.easypayments.command.annotation.PluginEnableRequired;
import ru.easydonate.easypayments.command.exception.ExecutionException;
import ru.easydonate.easypayments.command.exception.InitializationException;
import ru.easydonate.easypayments.core.config.localized.Messages;
import ru.easydonate.easypayments.database.model.Customer;
import ru.easydonate.easypayments.database.model.Payment;
import ru.easydonate.easypayments.shopcart.ShopCart;
import ru.easydonate.easypayments.shopcart.ShopCartStorage;

@Command(value="transfer")
@Arguments(value={"source", "payment-id", "target"})
@PluginEnableRequired
@MinimalArgsCount(value=3)
@Permission(value="easypayments.command.cart.tranfer")
public final class CommandTransfer
extends CommandExecutor {
    private final EasyPaymentsPlugin plugin;
    private final ShopCartStorage shopCartStorage;

    public CommandTransfer(@NotNull EasyPaymentsPlugin plugin, @NotNull Messages messages, @NotNull ShopCartStorage shopCartStorage) throws InitializationException {
        super(messages);
        this.plugin = plugin;
        this.shopCartStorage = shopCartStorage;
    }

    @Override
    public void executeCommand(@NotNull CommandSender sender, @NotNull List<String> args) throws ExecutionException {
        int paymentId;
        this.validateExecution(sender, args);
        String sourceName = args.get(0);
        String targetName = args.get(2);
        if (sourceName.isEmpty() || targetName.isEmpty() || sourceName.equals(targetName)) {
            this.throwWrongSyntax();
        }
        if ((paymentId = this.parsePaymentId(args.get(1))) == 0) {
            this.messages.getAndSend(sender, "cart-transfer.failed.bad-payment-id", new Object[0]);
            return;
        }
        CompletableFuture<Customer> targetCustomerFuture = this.shopCartStorage.getStorage().getCustomerByName(targetName);
        this.shopCartStorage.getStorage().getPayment(paymentId).thenAccept(payment -> {
            if (payment == null) {
                this.messages.getAndSend(sender, "cart-transfer.failed.payment-not-found", "%payment_id%", paymentId);
                return;
            }
            Customer sourceCustomer = payment.getCustomer();
            if (sourceCustomer == null || !sourceName.equals(sourceCustomer.getPlayerName())) {
                this.messages.getAndSend(sender, "cart-transfer.failed.payment-not-owned", "%payment_id%", paymentId, "%source%", sourceName);
                return;
            }
            if (!payment.hasPurchases()) {
                this.messages.getAndSend(sender, "cart-transfer.failed.no-purchases", "%payment_id%", paymentId);
                return;
            }
            if (payment.isCollected()) {
                this.messages.getAndSend(sender, "cart-transfer.failed.purchases-already-collected", "%payment_id%", paymentId);
                return;
            }
            Customer targetCustomer = (Customer)targetCustomerFuture.join();
            if (targetCustomer == null) {
                this.messages.getAndSend(sender, "cart-transfer.failed.target-cart-not-found", "%target%", targetName);
                return;
            }
            payment.transfer(targetCustomer);
            this.shopCartStorage.getStorage().savePayment((Payment)payment).thenRun(() -> {
                this.shopCartStorage.getStorage().refreshCustomer(sourceCustomer);
                this.shopCartStorage.getStorage().refreshCustomer(targetCustomer);
                this.messages.getAndSend(sender, "cart-transfer.success", "%source%", sourceName, "%payment_id%", paymentId, "%target%", targetName);
            });
        });
    }

    @Override
    @Nullable
    public List<String> provideTabCompletions(@NotNull CommandSender sender, @NotNull List<String> args) throws ExecutionException {
        Optional<ShopCart> cachedCart;
        this.validateExecution(sender);
        if (args.size() == 1 || args.size() == 3) {
            String arg = args.get(args.size() - 1).toLowerCase();
            return Arrays.stream(this.plugin.getServer().getOfflinePlayers()).map(OfflinePlayer::getName).distinct().filter(n -> n.toLowerCase().startsWith(arg)).collect(Collectors.toList());
        }
        if (args.size() == 2 && (cachedCart = this.shopCartStorage.getCached(args.get(0))).isPresent()) {
            return cachedCart.get().getPayments().stream().map(Payment::getId).map(String::valueOf).collect(Collectors.toList());
        }
        return null;
    }

    private int parsePaymentId(String arg) {
        try {
            return Math.max(0, Integer.parseInt(arg));
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }
}

