/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.command.shopcart;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.command.CommandExecutor;
import ru.easydonate.easypayments.command.annotation.Command;
import ru.easydonate.easypayments.command.annotation.CommandAliases;
import ru.easydonate.easypayments.command.annotation.OnlyForPlayers;
import ru.easydonate.easypayments.command.annotation.Permission;
import ru.easydonate.easypayments.command.annotation.PluginEnableRequired;
import ru.easydonate.easypayments.command.exception.ExecutionException;
import ru.easydonate.easypayments.command.exception.InitializationException;
import ru.easydonate.easypayments.core.config.localized.Messages;
import ru.easydonate.easypayments.database.model.Payment;
import ru.easydonate.easypayments.database.model.Purchase;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpRequestException;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpResponseException;
import ru.easydonate.easypayments.shopcart.ShopCart;
import ru.easydonate.easypayments.shopcart.ShopCartStorage;

@Command(value="get")
@CommandAliases(value={"all", "collect"})
@OnlyForPlayers
@PluginEnableRequired
@Permission(value="easypayments.command.cart.get")
public final class CommandGet
extends CommandExecutor {
    private final EasyPaymentsPlugin plugin;
    private final ShopCartStorage shopCartStorage;

    public CommandGet(@NotNull EasyPaymentsPlugin plugin, @NotNull Messages messages, @NotNull ShopCartStorage shopCartStorage) throws InitializationException {
        super(messages);
        this.plugin = plugin;
        this.shopCartStorage = shopCartStorage;
    }

    @Override
    public void executeCommand(@NotNull CommandSender sender, @NotNull List<String> args) throws ExecutionException {
        this.validateExecution(sender, args);
        Player player = (Player)sender;
        Optional<ShopCart> cachedCart = this.shopCartStorage.getCached(player.getName());
        if (!cachedCart.isPresent()) {
            this.plugin.getLogger().warning(String.format("%s's shop cart still isn't cached!", player.getName()));
            this.plugin.getLogger().warning("Probably a database connection is very slow...");
            throw new ExecutionException(this.messages.get("cart-get.failed.cart-unavailable", new Object[0]), new Object[0]);
        }
        ShopCart shopCart = cachedCart.get();
        Collection<Payment> cartContent = shopCart.getContent();
        if (cartContent.isEmpty()) {
            throw new ExecutionException(this.messages.get("cart-get.failed.no-purchases", new Object[0]), new Object[0]);
        }
        List uncollectedPurchases = cartContent.stream().filter(Payment::hasPurchases).map(Payment::getPurchases).flatMap(Collection::stream).filter(p -> !p.isCollected()).collect(Collectors.toList());
        this.issuePurchases(cartContent).thenRun(() -> {
            List purchases = uncollectedPurchases.stream().map(this::asBodyElement).collect(Collectors.toList());
            if (purchases.isEmpty()) {
                this.messages.getAndSend(sender, "cart-get.failed.no-purchases", new Object[0]);
                return;
            }
            ArrayList<String> message = new ArrayList<String>();
            message.add(this.messages.get("cart-get.header", new Object[0]));
            message.addAll(purchases);
            message.add(this.messages.get("cart-get.footer", new Object[0]));
            message.removeIf(String::isEmpty);
            this.messages.send(sender, String.join((CharSequence)"\n", message));
        });
    }

    @NotNull
    private CompletableFuture<Void> issuePurchases(@NotNull Collection<Payment> payments) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.plugin.getIssuancePerformService().issuePurchasesAndReport(payments, purchase -> !purchase.isCollected());
            }
            catch (HttpRequestException | HttpResponseException ex) {
                this.plugin.getLogger().severe("An unknown error occured while trying to upload reports!");
                this.plugin.getLogger().severe("Please, contact with the platform support:");
                this.plugin.getLogger().severe("https://vk.me/easydonate");
                this.plugin.getDebugLogger().error(ex);
            }
            catch (Throwable ex) {
                this.plugin.getDebugLogger().error("An unexpected error was occured!", new Object[0]);
                this.plugin.getDebugLogger().error(ex);
            }
        });
    }

    @NotNull
    private String asBodyElement(@NotNull Purchase purchase) {
        String name = purchase.getName();
        int amount = purchase.getAmount();
        LocalDateTime createdAt = purchase.getCreatedAt();
        return this.messages.get("cart-get.body", "%name%", name != null ? name : this.getNoValueStub(), "%amount%", Math.max(amount, 1), "%time_ago%", this.plugin.getRelativeTimeFormatter().formatElapsedTime(createdAt));
    }

    @NotNull
    private String getNoValueStub() {
        return this.messages.get("cart-get.no-value-stub", new Object[0]);
    }
}

