/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.command.shopcart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.command.CommandExecutor;
import ru.easydonate.easypayments.command.annotation.Arguments;
import ru.easydonate.easypayments.command.annotation.Command;
import ru.easydonate.easypayments.command.annotation.CommandAliases;
import ru.easydonate.easypayments.command.annotation.Permission;
import ru.easydonate.easypayments.command.annotation.PluginEnableRequired;
import ru.easydonate.easypayments.command.exception.ExecutionException;
import ru.easydonate.easypayments.command.exception.InitializationException;
import ru.easydonate.easypayments.core.config.localized.Messages;
import ru.easydonate.easypayments.core.easydonate4j.EventType;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventUpdateReport;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventUpdateReports;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.object.NewPaymentReport;
import ru.easydonate.easypayments.database.model.Payment;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpRequestException;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpResponseException;
import ru.easydonate.easypayments.shopcart.ShopCart;
import ru.easydonate.easypayments.shopcart.ShopCartStorage;

@Command(value="clear")
@CommandAliases(value={"delete", "reset"})
@Arguments(value={"player"})
@PluginEnableRequired
@Permission(value="easypayments.command.cart.clear")
public final class CommandClear
extends CommandExecutor {
    private static final String CLEAR_OTHERS_PERMISSION = "easypayments.command.cart.clear.other";
    private final EasyPaymentsPlugin plugin;
    private final ShopCartStorage shopCartStorage;

    public CommandClear(@NotNull EasyPaymentsPlugin plugin, @NotNull Messages messages, @NotNull ShopCartStorage shopCartStorage) throws InitializationException {
        super(messages);
        this.plugin = plugin;
        this.shopCartStorage = shopCartStorage;
    }

    @Override
    public void executeCommand(@NotNull CommandSender sender, @NotNull List<String> args) throws ExecutionException {
        this.validateExecution(sender, args);
        if (!args.isEmpty() && sender.hasPermission(CLEAR_OTHERS_PERMISSION)) {
            this.clearCart(sender, args.get(0), !this.isPlayer(sender) || !sender.getName().equals(args.get(0)));
            return;
        }
        if (!this.isPlayer(sender)) {
            this.throwWrongSyntax();
        }
        this.clearCart(sender, sender.getName(), false);
    }

    @Override
    @Nullable
    public List<String> provideTabCompletions(@NotNull CommandSender sender, @NotNull List<String> args) throws ExecutionException {
        this.validateExecution(sender, args);
        if (args.size() != 1) {
            return null;
        }
        String arg = args.get(0).toLowerCase();
        if (sender.hasPermission(CLEAR_OTHERS_PERMISSION)) {
            return Arrays.stream(this.plugin.getServer().getOfflinePlayers()).map(OfflinePlayer::getName).distinct().filter(n -> n.toLowerCase().startsWith(arg)).collect(Collectors.toList());
        }
        if (this.isPlayer(sender) && sender.getName().toLowerCase().startsWith(arg)) {
            return Collections.singletonList(sender.getName());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void clearCart(@NotNull CommandSender sender, @NotNull String playerName, boolean browsingOthers) throws ExecutionException {
        String messagesRoot = browsingOthers ? "cart-clear.other" : "cart-clear.yourself";
        CompletableFuture<ShopCart> shopCartFuture = new CompletableFuture<ShopCart>();
        Optional<ShopCart> cachedCart = this.shopCartStorage.getCached(playerName);
        if (!browsingOthers) {
            if (!cachedCart.isPresent()) {
                this.plugin.getLogger().warning(String.format("%s's shop cart still isn't cached!", playerName));
                this.plugin.getLogger().warning("Probably a database connection is very slow...");
                throw new ExecutionException(this.messages.get(messagesRoot + ".failed.cart-unavailable", new Object[0]), new Object[0]);
            }
            shopCartFuture.complete(cachedCart.get());
        } else if (cachedCart.isPresent()) {
            shopCartFuture.complete(cachedCart.get());
        } else {
            this.shopCartStorage.getAndCache(playerName).thenAccept(shopCartFuture::complete);
        }
        shopCartFuture.thenAccept(shopCart -> {
            if (shopCart == null || shopCart.isEmpty()) {
                this.messages.getAndSend(sender, messagesRoot + ".failed.no-purchases", "%player%", playerName);
                return;
            }
            ArrayList collectedPayments = new ArrayList();
            CompletableFuture[] futures = (CompletableFuture[])shopCart.getPayments().stream().filter(Payment::markAsCollected).peek(collectedPayments::add).map(this.shopCartStorage.getStorage()::savePayment).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(futures).thenAccept(v -> {
                List reports = collectedPayments.stream().mapToInt(Payment::getId).mapToObj(paymentId -> NewPaymentReport.createCartClearReport(paymentId, playerName)).collect(Collectors.toList());
                EventUpdateReport updateReport = new EventUpdateReport(EventType.NEW_PAYMENT, reports);
                EventUpdateReports updateReports = new EventUpdateReports(updateReport);
                try {
                    this.plugin.getIssuanceReportService().uploadReports(updateReports);
                }
                catch (HttpRequestException | HttpResponseException ex) {
                    this.plugin.getLogger().severe("An unknown error occured while trying to upload reports!");
                    this.plugin.getLogger().severe("Please, contact with the platform support:");
                    this.plugin.getLogger().severe("https://vk.me/easydonateru");
                    ex.printStackTrace();
                }
                this.messages.getAndSend(sender, messagesRoot + ".success", "%player%", playerName);
            });
        });
    }
}

