/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.command.help;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.command.help.HelpMessageFactory;
import ru.easydonate.easypayments.core.formatting.StringFormatter;

public final class HelpMessageLine {
    private final HelpMessageFactory parentFactory;
    private final List<Supplier<String>> arguments;
    private String command;
    private Supplier<String> description;
    private String permission;

    HelpMessageLine(@NotNull HelpMessageFactory parentFactory) {
        this.parentFactory = parentFactory;
        this.arguments = new ArrayList<Supplier<String>>();
    }

    void formatAsMessageLine(@NotNull Permissible receiver, @NotNull String lineFormat, @NotNull List<String> content) {
        if (this.command == null || !this.hasPermissionToSee(receiver)) {
            return;
        }
        StringBuilder commandLine = new StringBuilder(this.command);
        if (!this.arguments.isEmpty()) {
            for (Supplier<String> argument : this.arguments) {
                commandLine.append(' ').append(argument.get());
            }
        }
        content.add(StringFormatter.format(lineFormat, "%command%", commandLine.toString(), "%description%", this.getNonNullDescription().get()));
    }

    @NotNull
    public HelpMessageFactory add() {
        return this.parentFactory.addLine(this);
    }

    @NotNull
    public HelpMessageLine withCommand(@NotNull String command) {
        return this.withCommand(command, true);
    }

    @NotNull
    public HelpMessageLine withCommand(@NotNull String command, boolean useAsDefaultKey) {
        this.command = command;
        if (useAsDefaultKey) {
            this.withDescriptionFrom(command);
            this.withPermission(command);
        }
        return this;
    }

    @NotNull
    public HelpMessageLine withArgument(@NotNull String argument) {
        this.arguments.add(() -> argument);
        return this;
    }

    @NotNull
    public HelpMessageLine withArguments(String ... arguments) {
        for (String argument : arguments) {
            this.withArgument(argument);
        }
        return this;
    }

    @NotNull
    public HelpMessageLine withArgumentFrom(@NotNull String key) {
        Supplier<String> argument = key.startsWith("$") ? () -> this.parentFactory.getMessages().get(key.substring(1), new Object[0]) : this.parentFactory.getArgument(key);
        this.arguments.add(argument);
        return this;
    }

    @NotNull
    public HelpMessageLine withArgumentsFrom(String ... keys) {
        for (String key : keys) {
            this.withArgumentFrom(key);
        }
        return this;
    }

    @NotNull
    public HelpMessageLine withDescription(@NotNull String description) {
        this.description = () -> description;
        return this;
    }

    @NotNull
    public HelpMessageLine withDescriptionFrom(@NotNull String key) {
        return this.withDescriptionFrom(key, true);
    }

    @NotNull
    public HelpMessageLine withDescriptionFrom(@NotNull String key, boolean useDefaultFormat) {
        this.description = useDefaultFormat ? this.parentFactory.getDescription(key) : () -> this.parentFactory.getMessages().get(key, new Object[0]);
        return this;
    }

    @NotNull
    public HelpMessageLine withPermission(@NotNull String key) {
        return this.withPermission(key, true);
    }

    @NotNull
    public HelpMessageLine withPermission(@NotNull String key, boolean useDefaultFormat) {
        this.permission = useDefaultFormat ? this.parentFactory.getPermission(key) : key;
        return this;
    }

    public boolean hasPermission() {
        return this.permission != null && !this.permission.isEmpty();
    }

    public boolean hasPermissionToSee(@NotNull Permissible permissible) {
        return !this.hasPermission() || permissible.hasPermission(this.permission);
    }

    @NotNull
    private Supplier<String> getNonNullDescription() {
        return this.description != null ? this.description : () -> this.command;
    }
}

