/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.command.easypayments.setup;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.command.CommandExecutor;
import ru.easydonate.easypayments.command.annotation.Arguments;
import ru.easydonate.easypayments.command.annotation.Command;
import ru.easydonate.easypayments.command.annotation.CommandAliases;
import ru.easydonate.easypayments.command.annotation.MinimalArgsCount;
import ru.easydonate.easypayments.command.annotation.Permission;
import ru.easydonate.easypayments.command.exception.ExecutionException;
import ru.easydonate.easypayments.command.exception.InitializationException;
import ru.easydonate.easypayments.core.config.Configuration;
import ru.easydonate.easypayments.core.config.localized.Messages;

@Command(value="server-id")
@CommandAliases(value={"server", "sid"})
@Arguments(value={"server-id"})
@MinimalArgsCount(value=1)
@Permission(value="easypayments.command.setup")
public final class CommandServerId
extends CommandExecutor {
    private final Configuration config;

    public CommandServerId(@NotNull Configuration config, @NotNull Messages messages) throws InitializationException {
        super(messages);
        this.config = config;
    }

    @Override
    public void executeCommand(@NotNull CommandSender sender, @NotNull List<String> args) throws ExecutionException {
        this.validateExecution(sender, args);
        try {
            int serverId = Integer.parseInt(args.get(0));
            if (serverId > 0) {
                this.config.getOverrides().put("server-id", serverId);
                this.config.reload();
                this.messages.getAndSend(sender, "setup.success.server-id", "%server_id%", serverId);
                if (this.config.getString("key", "").isEmpty()) {
                    this.messages.getAndSend(sender, "setup.tips.access-key", new Object[0]);
                }
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new ExecutionException(this.messages.get("setup.failed.wrong-server-id", new Object[0]), new Object[0]);
    }
}

