/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.command.easypayments;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.command.CommandExecutor;
import ru.easydonate.easypayments.command.annotation.Command;
import ru.easydonate.easypayments.command.annotation.CommandAliases;
import ru.easydonate.easypayments.command.annotation.Permission;
import ru.easydonate.easypayments.command.exception.ExecutionException;
import ru.easydonate.easypayments.command.exception.InitializationException;
import ru.easydonate.easypayments.core.config.localized.Messages;
import ru.easydonate.easypayments.core.formatting.StringFormatter;
import ru.easydonate.easypayments.core.platform.provider.PlatformProvider;
import ru.easydonate.easypayments.core.platform.provider.PlatformResolverState;

@Command(value="status")
@CommandAliases(value={"i", "info"})
@Permission(value="easypayments.command.status")
public final class CommandStatus
extends CommandExecutor {
    private final EasyPaymentsPlugin plugin;

    public CommandStatus(@NotNull EasyPaymentsPlugin plugin, @NotNull Messages messages) throws InitializationException {
        super(messages);
        this.plugin = plugin;
    }

    @Override
    public void executeCommand(@NotNull CommandSender sender, @NotNull List<String> args) throws ExecutionException {
        PlatformProvider platformProvider;
        this.validateExecution(sender, args);
        boolean isPluginEnabled = EasyPaymentsPlugin.isPluginEnabled();
        boolean isStorageAvailable = EasyPaymentsPlugin.isStorageAvailable();
        boolean isPlayersSyncingActive = this.plugin.isPlayersSyncActive();
        boolean isPurchasesIssuanceActive = this.plugin.isPurchasesIssuanceActive();
        String noValueStub = this.getNoValueStub();
        String accessKey = StringFormatter.maskAccessKey(this.plugin.getAccessKey());
        int serverId = this.plugin.getServerId();
        String effectiveExecutorName = noValueStub;
        Object effectivePermissionLevel = noValueStub;
        String effectivePlatformType = noValueStub;
        String effectivePlatformName = noValueStub;
        PlatformResolverState resolverState = this.plugin.getPlatformResolverState();
        if (resolverState != null) {
            int permissionLevel;
            String executorName = resolverState.getExecutorName();
            if (executorName != null) {
                effectiveExecutorName = executorName;
            }
            if ((permissionLevel = resolverState.getPermissionLevel()) > 0) {
                effectivePermissionLevel = permissionLevel;
            }
        }
        if ((platformProvider = this.plugin.getPlatformProvider()) != null) {
            PlatformProvider.ImplementationType implementationType = platformProvider.getImplementationType();
            String implementationKey = implementationType.getKey();
            effectivePlatformType = this.messages.get(String.format("status.platform-type.%s", implementationKey), new Object[0]);
            effectivePlatformName = platformProvider.getPlatformType().getName();
            effectiveExecutorName = this.messages.getOrDefault(String.format("status.executor-name.%s", implementationKey), effectiveExecutorName, new Object[0]);
        }
        this.messages.getAndSend(sender, "status.message", "%plugin_version%", this.plugin.getDescription().getVersion(), "%plugin_status%", this.wrapBoolean(isPluginEnabled, "plugin-status", "working", "unconfigured"), "%storage_status%", this.wrapBoolean(isStorageAvailable, "storage-status", "available", "unavailable"), "%platform_type%", effectivePlatformType, "%platform_name%", effectivePlatformName, "%mode_issue_purchases%", this.wrapBoolean(isPurchasesIssuanceActive, "plugin-mode", "active", "inactive"), "%mode_sync_players%", this.wrapBoolean(isPlayersSyncingActive, "plugin-mode", "active", "inactive"), "%access_key%", accessKey != null && !accessKey.isEmpty() ? accessKey : noValueStub, "%server_id%", serverId > 0 ? "#" + serverId : noValueStub, "%executor_name%", effectiveExecutorName, "%permission_level%", effectivePermissionLevel);
    }

    @NotNull
    private String getNoValueStub() {
        return this.messages.get("status.no-value-stub", new Object[0]);
    }

    @NotNull
    private String wrapBoolean(boolean value, @NotNull String subKey, @NotNull String trueKey, @NotNull String falseKey) {
        return this.messages.get(String.format("status.%s.%s", subKey, value ? trueKey : falseKey), new Object[0]);
    }
}

