/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.command.easypayments;

import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.command.CommandDispatcher;
import ru.easydonate.easypayments.command.annotation.Command;
import ru.easydonate.easypayments.command.annotation.CommandAliases;
import ru.easydonate.easypayments.command.annotation.Permission;
import ru.easydonate.easypayments.command.easypayments.setup.CommandAccessKey;
import ru.easydonate.easypayments.command.easypayments.setup.CommandServerId;
import ru.easydonate.easypayments.command.exception.ExecutionException;
import ru.easydonate.easypayments.command.exception.InitializationException;
import ru.easydonate.easypayments.core.config.Configuration;
import ru.easydonate.easypayments.core.config.localized.Messages;
import ru.easydonate.easypayments.exception.UnsupportedCallerException;
import ru.easydonate.easypayments.setup.InteractiveSetupProvider;

@Command(value="setup")
@CommandAliases(value={"config", "configure"})
@Permission(value="easypayments.command.setup")
public final class CommandSetup
extends CommandDispatcher {
    private final InteractiveSetupProvider setupProvider;

    public CommandSetup(@NotNull Configuration config, @NotNull Messages messages, @NotNull InteractiveSetupProvider setupProvider) throws InitializationException {
        super(messages);
        this.setupProvider = setupProvider;
        this.registerChild(new CommandAccessKey(config, messages));
        this.registerChild(new CommandServerId(config, messages));
    }

    @Override
    protected void onUsageWithoutArgs(@NotNull CommandSender sender) throws ExecutionException {
        this.validateExecution(sender);
        if (this.setupProvider.hasSession(sender)) {
            this.setupProvider.closeSession(sender);
            this.messages.getAndSend(sender, "setup.exit", new Object[0]);
        } else {
            try {
                this.setupProvider.openSession(sender, true);
            }
            catch (UnsupportedCallerException ex) {
                this.messages.getAndSend(sender, "error.unsupported-caller", new Object[0]);
            }
        }
    }
}

