/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.command.easypayments;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.command.CommandExecutor;
import ru.easydonate.easypayments.command.annotation.Command;
import ru.easydonate.easypayments.command.annotation.CommandAliases;
import ru.easydonate.easypayments.command.annotation.Permission;
import ru.easydonate.easypayments.command.exception.ExecutionException;
import ru.easydonate.easypayments.command.exception.InitializationException;
import ru.easydonate.easypayments.core.config.localized.Messages;

@Command(value="reload")
@CommandAliases(value={"r", "refresh"})
@Permission(value="easypayments.command.reload")
public final class CommandReload
extends CommandExecutor {
    private final EasyPaymentsPlugin plugin;

    public CommandReload(@NotNull EasyPaymentsPlugin plugin, @NotNull Messages messages) throws InitializationException {
        super(messages);
        this.plugin = plugin;
    }

    @Override
    public void executeCommand(@NotNull CommandSender sender, @NotNull List<String> args) throws ExecutionException {
        this.validateExecution(sender, args);
        CompletableFuture.runAsync(() -> {
            try {
                this.plugin.reload();
                this.messages.getAndSend(sender, "reload.success", new Object[0]);
            }
            catch (Exception ex) {
                this.messages.getAndSend(sender, "reload.failed.some-error-occurred", "%error_message%", ex.getMessage(), "%troubleshooting_page_url%", "https://easypayments.easydonate.ru");
            }
        });
    }
}

