/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.command;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.command.Executor;
import ru.easydonate.easypayments.command.annotation.Arguments;
import ru.easydonate.easypayments.command.annotation.Command;
import ru.easydonate.easypayments.command.annotation.CommandAliases;
import ru.easydonate.easypayments.command.annotation.MinimalArgsCount;
import ru.easydonate.easypayments.command.annotation.OnlyForPlayers;
import ru.easydonate.easypayments.command.annotation.Permission;
import ru.easydonate.easypayments.command.annotation.PluginEnableRequired;
import ru.easydonate.easypayments.command.exception.ExecutionException;
import ru.easydonate.easypayments.command.exception.InitializationException;
import ru.easydonate.easypayments.core.config.localized.Messages;

public abstract class CommandExecutor
implements Executor {
    protected CommandExecutor parent;
    protected final Messages messages;
    private final String command;
    private final String[] aliases;
    private final String[] arguments;
    private final int minimalArgsCount;
    private final boolean onlyForPlayers;
    private final boolean pluginEnableRequired;
    private final String permission;

    protected CommandExecutor(@NotNull Messages messages) throws InitializationException {
        this.messages = messages;
        this.command = this.resolveCommand();
        this.aliases = this.resolveCommandAliases();
        this.arguments = this.resolveArguments();
        this.minimalArgsCount = this.resolveMinimalArgsCount();
        this.onlyForPlayers = this.resolveOnlyForPlayersStatus();
        this.pluginEnableRequired = this.resolvePluginEnableRequiredStatus();
        this.permission = this.resolvePermission();
    }

    public void setParent(@NotNull CommandExecutor parent) {
        this.parent = parent;
    }

    public void register(@NotNull EasyPaymentsPlugin plugin) {
        PluginCommand pluginCommand = plugin.getCommand(this.command);
        if (pluginCommand != null) {
            pluginCommand.setExecutor((org.bukkit.command.CommandExecutor)this);
            pluginCommand.setTabCompleter((TabCompleter)this);
        }
    }

    @NotNull
    public String resolveFullCommand() {
        StringBuilder fullCommand = new StringBuilder();
        if (this.parent != null) {
            fullCommand.append(this.parent.resolveFullCommand()).append(' ');
        }
        fullCommand.append(this.command);
        return fullCommand.toString();
    }

    protected void validateExecution(@NotNull CommandSender sender) throws ExecutionException {
        this.validateExecution(sender, Collections.emptyList());
    }

    protected void validateExecution(@NotNull CommandSender sender, @NotNull List<String> args) throws ExecutionException {
        this.checkFeatureAvailability();
        this.checkPermission(sender);
        this.checkCommandSender(sender);
        this.checkCommandSyntax(sender, args);
    }

    protected void checkPermission(@NotNull CommandSender sender) throws ExecutionException {
        if (this.permission != null && !sender.hasPermission(this.permission)) {
            this.throwNoPermissions();
        }
    }

    protected void throwNoPermissions() throws ExecutionException {
        throw new ExecutionException(this.messages.get("error.no-permissions", new Object[0]), new Object[0]);
    }

    protected void checkCommandSender(@NotNull CommandSender sender) throws ExecutionException {
        if (this.onlyForPlayers && !this.isPlayer(sender)) {
            this.throwOnlyForPlayers();
        }
    }

    protected void throwOnlyForPlayers() throws ExecutionException {
        throw new ExecutionException(this.messages.get("error.only-for-players", new Object[0]), new Object[0]);
    }

    protected void checkCommandSyntax(@NotNull CommandSender sender, @NotNull List<String> args) throws ExecutionException {
        if (this.minimalArgsCount > args.size()) {
            this.throwWrongSyntax();
        }
    }

    protected void throwWrongSyntax() throws ExecutionException {
        throw new ExecutionException(this.messages.get("error.wrong-syntax", "%correct_syntax%", this.resolveCorrectSyntax()), new Object[0]);
    }

    protected void checkFeatureAvailability() throws ExecutionException {
        if (this.pluginEnableRequired && !EasyPaymentsPlugin.isPluginEnabled()) {
            this.throwUnavailableFeature();
        }
    }

    protected void throwUnavailableFeature() throws ExecutionException {
        throw new ExecutionException(this.messages.get("error.unavailable-feature", new Object[0]), new Object[0]);
    }

    protected boolean isPlayer(@NotNull CommandSender sender) {
        return sender instanceof Player;
    }

    @NotNull
    private String resolveCommand() throws InitializationException {
        return this.getAnnotation(Command.class).map(Command::value).orElseThrow(() -> InitializationException.NO_COMMAND_SPECIFIED);
    }

    @Nullable
    private String[] resolveCommandAliases() {
        return this.getAnnotation(CommandAliases.class).map(CommandAliases::value).orElse(null);
    }

    @Nullable
    private String[] resolveArguments() {
        return this.getAnnotation(Arguments.class).map(Arguments::value).orElse(null);
    }

    @NotNull
    private String resolveCorrectSyntax() {
        StringBuilder syntax = new StringBuilder().append('/').append(this.resolveFullCommand());
        if (this.arguments != null) {
            for (String key : this.arguments) {
                String argument = this.messages.getOrDefault("help.arguments." + key, '<' + key + '>', new Object[0]);
                syntax.append(' ').append(argument);
            }
        }
        return syntax.toString();
    }

    private int resolveMinimalArgsCount() {
        return this.getAnnotation(MinimalArgsCount.class).map(MinimalArgsCount::value).orElse(0);
    }

    private boolean resolveOnlyForPlayersStatus() {
        return this.getAnnotation(OnlyForPlayers.class).isPresent();
    }

    private boolean resolvePluginEnableRequiredStatus() {
        return this.getAnnotation(PluginEnableRequired.class).isPresent();
    }

    @NotNull
    private String resolvePermission() {
        return this.getAnnotation(Permission.class).map(Permission::value).orElse(null);
    }

    @NotNull
    private <T extends Annotation> Optional<T> getAnnotation(@NotNull Class<T> annotationType) {
        return Optional.ofNullable(this.getClass().getAnnotation(annotationType));
    }

    @Generated
    public CommandExecutor getParent() {
        return this.parent;
    }

    @Override
    @Generated
    public Messages getMessages() {
        return this.messages;
    }

    @Override
    @Generated
    public String getCommand() {
        return this.command;
    }

    @Override
    @Generated
    public String[] getAliases() {
        return this.aliases;
    }

    @Generated
    public String[] getArguments() {
        return this.arguments;
    }

    @Generated
    public int getMinimalArgsCount() {
        return this.minimalArgsCount;
    }

    @Generated
    public boolean isOnlyForPlayers() {
        return this.onlyForPlayers;
    }

    @Generated
    public boolean isPluginEnableRequired() {
        return this.pluginEnableRequired;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }
}

