/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments;

import java.util.Calendar;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.command.easypayments.CommandEasyPayments;
import ru.easydonate.easypayments.command.exception.ExecutionException;
import ru.easydonate.easypayments.command.exception.InitializationException;
import ru.easydonate.easypayments.command.shopcart.CommandShopCart;
import ru.easydonate.easypayments.core.EasyPayments;
import ru.easydonate.easypayments.core.config.Configuration;
import ru.easydonate.easypayments.core.config.localized.Messages;
import ru.easydonate.easypayments.core.config.template.TemplateConfiguration;
import ru.easydonate.easypayments.core.easydonate4j.extension.client.EasyPaymentsClient;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.PluginStateModel;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.PluginVersionModel;
import ru.easydonate.easypayments.core.exception.ConfigurationValidationException;
import ru.easydonate.easypayments.core.formatting.RelativeTimeFormatter;
import ru.easydonate.easypayments.core.interceptor.InterceptorFactory;
import ru.easydonate.easypayments.core.logging.DebugLogger;
import ru.easydonate.easypayments.core.platform.UnsupportedPlatformException;
import ru.easydonate.easypayments.core.platform.provider.PlatformProvider;
import ru.easydonate.easypayments.core.platform.provider.PlatformProviderBase;
import ru.easydonate.easypayments.core.platform.provider.PlatformResolver;
import ru.easydonate.easypayments.core.platform.provider.PlatformResolverState;
import ru.easydonate.easypayments.core.util.AnsiColorizer;
import ru.easydonate.easypayments.database.Database;
import ru.easydonate.easypayments.database.DatabaseManager;
import ru.easydonate.easypayments.database.model.Customer;
import ru.easydonate.easypayments.database.model.Payment;
import ru.easydonate.easypayments.database.model.Purchase;
import ru.easydonate.easypayments.database.persister.LocalDateTimePersister;
import ru.easydonate.easypayments.exception.CredentialsParseException;
import ru.easydonate.easypayments.exception.DriverLoadException;
import ru.easydonate.easypayments.exception.DriverNotFoundException;
import ru.easydonate.easypayments.exception.PluginUnavailableException;
import ru.easydonate.easypayments.exception.StorageLoadException;
import ru.easydonate.easypayments.libs.ormlite.logger.Level;
import ru.easydonate.easypayments.libs.ormlite.logger.Logger;
import ru.easydonate.easypayments.listener.CommandPreProcessListener;
import ru.easydonate.easypayments.listener.PlayerJoinQuitListener;
import ru.easydonate.easypayments.service.IssuancePerformService;
import ru.easydonate.easypayments.service.IssuanceReportService;
import ru.easydonate.easypayments.service.KnownPlayersService;
import ru.easydonate.easypayments.service.LongPollEventDispatcher;
import ru.easydonate.easypayments.service.PersistanceService;
import ru.easydonate.easypayments.service.execution.ExecutionService;
import ru.easydonate.easypayments.setup.InteractiveSetupProvider;
import ru.easydonate.easypayments.shopcart.ShopCartConfig;
import ru.easydonate.easypayments.shopcart.ShopCartStorage;
import ru.easydonate.easypayments.task.KnownPlayersSyncTask;
import ru.easydonate.easypayments.task.PaymentsQueryTask;
import ru.easydonate.easypayments.task.PluginTask;
import ru.easydonate.easypayments.task.ReportCacheWorker;

public class EasyPaymentsPlugin
extends JavaPlugin
implements EasyPayments {
    public static final String TROUBLESHOOTING_PAGE_URL = "https://easypayments.easydonate.ru";
    public static final String SUPPORT_URL = "https://vk.me/easydonate";
    public static final String USER_AGENT_FORMAT = "EasyPayments %s";
    public static final int ACCESS_KEY_LENGTH = 32;
    public static final Pattern ACCESS_KEY_REGEX = Pattern.compile("[a-f\\d]{32}");
    public static final String CONFIG_KEY_ACCESS_KEY = "key";
    public static final String CONFIG_KEY_SERVER_ID = "server-id";
    public static final int STATE_QUERY_ATTEMPTS = 5;
    private static EasyPaymentsPlugin instance;
    private final DebugLogger debugLogger = new DebugLogger(this);
    private final String userAgent = String.format("EasyPayments %s", this.getDescription().getVersion());
    private final Lock reloadLock = new ReentrantLock();
    private final Lock syncLock = new ReentrantLock();
    private volatile boolean pluginEnabled = true;
    private volatile boolean pluginConfigured;
    private final Configuration config = new TemplateConfiguration(this, "config.yml");
    private final Messages messages;
    private final ShopCartConfig shopCartConfig;
    private DatabaseManager databaseManager;
    private PersistanceService persistanceService;
    private PlatformResolver platformResolver;
    private PlatformResolverState platformResolverState;
    private PlatformProvider platformProvider;
    private EasyPaymentsClient easyPaymentsClient;
    private InteractiveSetupProvider setupProvider;
    private ShopCartStorage shopCartStorage;
    private ExecutionService executionService;
    private LongPollEventDispatcher lpEventDispatcher;
    private IssuanceReportService issuanceReportService;
    private IssuancePerformService issuancePerformService;
    private KnownPlayersService knownPlayersService;
    private RelativeTimeFormatter relativeTimeFormatter;
    private PluginStateModel pluginStateModel;
    private PluginVersionModel pluginVersionModel;
    private PluginTask knownPlayersSyncTask;
    private PluginTask paymentsQueryTask;
    private PluginTask reportCacheWorker;
    private String accessKey;
    private int serverId;

    public EasyPaymentsPlugin() {
        this.config.registerKeyAliases("shop-cart.enabled", "use-shop-cart");
        this.config.setValidator(this::validateConfiguration);
        this.messages = new Messages(this, this.config);
        this.shopCartConfig = new ShopCartConfig(this.config, this.debugLogger);
        this.platformResolverState = PlatformResolverState.DEFAULT;
        this.pluginStateModel = PluginStateModel.DEFAULT;
    }

    public void onEnable() {
        instance = this;
        this.debugLogger.info("--- STATE: ENABLING ---", new Object[0]);
        try {
            this.loadConfigurations();
            this.changeEnabledState(true);
        }
        catch (ConfigurationValidationException ex) {
            this.debugLogger.error("Configuration validation failed", new Object[0]);
            this.debugLogger.error(ex);
            this.changeEnabledState(false);
            this.reportException(ex);
        }
        if (!this.initializePlatformImplementation()) {
            return;
        }
        this.initializeApiClient();
        CompletableFuture<PluginStateModel> future = this.deferRemoteStateQuery();
        try {
            this.loadStorage();
        }
        catch (StorageLoadException ex) {
            this.debugLogger.error("Storage loading failed", new Object[0]);
            this.debugLogger.error(ex);
            this.changeEnabledState(false);
        }
        this.debugLogger.debug("Initializing interactive setup...", new Object[0]);
        this.setupProvider = new InteractiveSetupProvider(this, this.config, this.messages);
        this.debugLogger.debug("Initializing shop cart storage...", new Object[0]);
        this.shopCartStorage = new ShopCartStorage(this);
        this.relativeTimeFormatter = new RelativeTimeFormatter(this.messages);
        this.loadServices();
        this.registerCommands();
        this.registerListeners();
        this.awaitRemoteStateQuery(future);
        if (this.pluginEnabled()) {
            this.launchTasks();
            this.info(" ", new Object[0]);
            this.info(" &eEasyPayments &ris an official payment processing implementation.", new Object[0]);
            this.info(" &6\u00a9 EasyDonate 2020-%d &r- All rights reserved.", Calendar.getInstance().get(1));
            this.info(" ", new Object[0]);
        }
        this.platformProvider.getScheduler().runAsyncNow(this, this::checkForUpdates);
        this.debugLogger.info("--- STATE: ENABLED ---", new Object[0]);
    }

    public void onDisable() {
        this.debugLogger.info("--- STATE: DISABLING ---", new Object[0]);
        this.closeTasks();
        this.shutdownServices();
        this.shutdownApiClient();
        this.closeStorage();
        this.changeEnabledState(false);
        this.debugLogger.info("--- STATE: DISABLED ---", new Object[0]);
        this.debugLogger.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() throws ConfigurationValidationException, StorageLoadException {
        this.reloadLock.lock();
        try {
            this.debugLogger.info("--- STATE: RELOADING ---", new Object[0]);
            this.closeTasks();
            this.shutdownServices();
            this.shutdownApiClient();
            this.closeStorage();
            this.changeEnabledState(false);
            PlatformResolverState currentState = this.platformResolverState;
            this.loadConfigurations();
            boolean requiresPlatformResolve = this.platformResolverState.requiresPlatformResolve(currentState);
            boolean requiresPlatformUpdate = this.platformResolverState.requiresPlatformUpdate(currentState);
            if (requiresPlatformResolve) {
                try {
                    this.resolvePlatformImplementation();
                    requiresPlatformUpdate = false;
                }
                catch (UnsupportedPlatformException ex) {
                    this.debugLogger.warn("[Platform] Couldn't resolve effective platform implementation!", new Object[0]);
                    this.debugLogger.warn(ex);
                    this.warn("Couldn't resolve effective platform implementation!", new Object[0]);
                    if (ex.getMessage() != null) {
                        this.warn("Failure reason: '%s'", ex.getMessage());
                    }
                    if (this.platformProvider != null) {
                        this.warn("Continue to use current platform: '%s'...", this.platformProvider.getDisplayName());
                    }
                    this.error("There is no platform implementation available!", new Object[0]);
                    this.getServer().getPluginManager().disablePlugin((Plugin)this);
                    this.reloadLock.unlock();
                    return;
                }
            }
            if (requiresPlatformUpdate && this.platformProvider != null) {
                this.debugLogger.debug("Updating interceptor factory with executor name '{0}' and permission level '{1}'", this.platformResolverState.getExecutorName(), this.platformResolverState.getPermissionLevel());
                ((PlatformProviderBase)this.platformProvider).updateInterceptorFactory(this.platformResolverState);
            }
            this.changeEnabledState(true);
            this.initializeApiClient();
            CompletableFuture<PluginStateModel> future = this.deferRemoteStateQuery();
            this.loadStorage();
            this.loadServices();
            this.awaitRemoteStateQuery(future);
            this.launchTasks();
            this.debugLogger.info("--- STATE: RELOADED ---", new Object[0]);
        }
        finally {
            this.reloadLock.unlock();
        }
    }

    private void loadConfigurations() throws ConfigurationValidationException {
        this.syncLock.lock();
        try {
            this.debugLogger.debug("Loading configurations...", new Object[0]);
            ConfigurationValidationException exception = null;
            try {
                this.config.reload();
                this.pluginConfigured = true;
            }
            catch (ConfigurationValidationException ex) {
                exception = ex;
                this.pluginConfigured = false;
            }
            this.messages.reload();
            this.shopCartConfig.reload();
            this.platformResolverState = PlatformResolverState.from(this.config);
            if (exception != null) {
                throw exception;
            }
        }
        finally {
            this.syncLock.unlock();
        }
    }

    private void loadStorage() throws StorageLoadException {
        this.syncLock.lock();
        try {
            this.debugLogger.debug("Loading storage...", new Object[0]);
            this.databaseManager = null;
            try {
                Database database = new Database(this, this.config).registerTables(Customer.class, Payment.class, Purchase.class).registerPersister(LocalDateTimePersister.getSingleton()).complete();
                this.databaseManager = new DatabaseManager(this, this.config, database);
                this.persistanceService = new PersistanceService(this, this.databaseManager);
            }
            catch (CredentialsParseException ex) {
                this.reportException(ex, "Couldn't parse a database connection credentials:", new Object[0]);
                throw new StorageLoadException(ex);
            }
            catch (DriverLoadException | DriverNotFoundException ex) {
                this.reportException(ex, "Couldn't load a database connection driver:", new Object[0]);
                throw new StorageLoadException(ex);
            }
            catch (Exception ex) {
                this.reportException(ex, "An error has occurred when this plugin tried to establish the database connection:", new Object[0]);
                this.disablePlugin();
                throw new StorageLoadException(ex);
            }
        }
        finally {
            this.syncLock.unlock();
        }
    }

    private void closeStorage() {
        this.syncLock.lock();
        try {
            if (this.databaseManager != null) {
                this.debugLogger.debug("Shutting down storage...", new Object[0]);
                this.databaseManager.shutdown();
            }
        }
        finally {
            this.syncLock.unlock();
        }
    }

    private void loadServices() {
        this.syncLock.lock();
        try {
            this.debugLogger.debug("Loading execution service...", new Object[0]);
            InterceptorFactory interceptorFactory = this.platformProvider.getInterceptorFactory();
            this.executionService = new ExecutionService(this, this.config, interceptorFactory);
            this.debugLogger.debug("Loading issuance report service...", new Object[0]);
            this.issuanceReportService = new IssuanceReportService(this, this.persistanceService, this.easyPaymentsClient);
            this.debugLogger.debug("Loading issuance perform service...", new Object[0]);
            this.issuancePerformService = new IssuancePerformService(this, this.issuanceReportService, this.executionService, this.persistanceService);
            this.debugLogger.debug("Loading LongPoll event dispatcher...", new Object[0]);
            this.lpEventDispatcher = new LongPollEventDispatcher(this, this.executionService);
            this.debugLogger.debug("Loading known players service...", new Object[0]);
            this.knownPlayersService = new KnownPlayersService();
        }
        finally {
            this.syncLock.unlock();
        }
    }

    private void shutdownServices() {
        this.syncLock.lock();
        try {
            if (this.lpEventDispatcher != null) {
                this.debugLogger.debug("Shutting down LongPoll event dispatcher...", new Object[0]);
                this.lpEventDispatcher.shutdown();
            }
            if (this.executionService != null) {
                this.debugLogger.debug("Shutting down execution service...", new Object[0]);
                this.executionService.shutdown();
            }
        }
        finally {
            this.syncLock.unlock();
        }
    }

    private void validateConfiguration(@NotNull Configuration config) throws ConfigurationValidationException {
        this.syncLock.lock();
        try {
            this.debugLogger.debug("[Validation] Validating configuration '{0}'...", config.getName());
            this.accessKey = config.getString(CONFIG_KEY_ACCESS_KEY);
            if (this.accessKey == null || this.accessKey.isEmpty()) {
                this.debugLogger.error("[Validation] Bad access key: '{0}'", this.accessKey);
                throw new ConfigurationValidationException("Please, specify your unique shop key in the config.yml!");
            }
            this.accessKey = this.accessKey.toLowerCase();
            if (this.accessKey.length() != 32 || !ACCESS_KEY_REGEX.matcher(this.accessKey).matches()) {
                this.debugLogger.error("[Validation] Bad access key: '{0}'", this.accessKey);
                throw new ConfigurationValidationException("Please, specify a VALID shop key (32 hex chars) in the config.yml!");
            }
            this.serverId = config.getInt(CONFIG_KEY_SERVER_ID, 0);
            if (this.serverId < 1) {
                this.debugLogger.error("[Validation] Bad server ID: '{0}'", this.serverId);
                throw new ConfigurationValidationException("Please, specify your valid server ID in the config.yml!");
            }
            this.debugLogger.debug("[Validation] Validation passed", new Object[0]);
            int logFileTTL = config.getInt("log-file-time-to-life");
            this.debugLogger.cleanLogsDir(logFileTTL);
        }
        finally {
            this.syncLock.unlock();
        }
    }

    private boolean initializePlatformImplementation() {
        this.debugLogger.debug("[Platform] Initializing platform implementation...", new Object[0]);
        try {
            this.platformResolver = new PlatformResolver(this, this.debugLogger);
            this.resolvePlatformImplementation();
            return true;
        }
        catch (UnsupportedPlatformException ex) {
            this.debugLogger.error("[Platform] Unsupported platform!", new Object[0]);
            this.debugLogger.error(ex);
            this.error("Couldn't find a platform implementation for your server software!", new Object[0]);
            if (ex.getMessage() != null) {
                this.error("Failure reason: '%s'", ex.getMessage());
            }
            this.error("----------------------------------------------------------------------", new Object[0]);
            this.error("Currently, EasyPayments plugin is compatible with:", new Object[0]);
            this.error("- Spigot: %s - %s", "1.8", "1.21.10");
            this.error("- Paper: %s or newer", "1.8.8");
            this.error("- Folia: %s or newer", "1.20.2");
            this.error("Proper plugin working on unlisted software isn't guaranteed.", new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
    }

    private void resolvePlatformImplementation() throws UnsupportedPlatformException {
        this.platformProvider = this.platformResolver.resolve(this.platformResolverState);
        this.info("Detected platform: &b%s", this.platformProvider.getDisplayName());
        this.debugLogger.info("[Platform] Using implementation: {0}", this.platformProvider.getClass().getName());
    }

    private void initializeApiClient() {
        if (!this.pluginConfigured) {
            return;
        }
        this.debugLogger.debug("Initializing EasyDonate API client...", new Object[0]);
        this.easyPaymentsClient = EasyPaymentsClient.create(this.accessKey, this.userAgent, this.serverId);
    }

    private void shutdownApiClient() {
        if (this.easyPaymentsClient != null) {
            this.debugLogger.debug("Shutting down EasyDonate API client...", new Object[0]);
            this.easyPaymentsClient.getLongPollClient().shutdown();
        }
    }

    private void registerCommands() throws InitializationException {
        this.debugLogger.debug("Registering commands...", new Object[0]);
        new CommandEasyPayments(this, this.config, this.messages, this.setupProvider);
        new CommandShopCart(this, this.messages, this.shopCartStorage);
    }

    private void registerListeners() {
        this.debugLogger.debug("Registering event listeners...", new Object[0]);
        new PlayerJoinQuitListener(this, this.messages, this.shopCartStorage, this.knownPlayersService);
        new CommandPreProcessListener(this, this.setupProvider);
    }

    private void launchTasks() {
        if (!this.pluginConfigured) {
            return;
        }
        this.debugLogger.debug("[Tasks] Launching plugin tasks...", new Object[0]);
        if (this.isPurchasesIssuanceActive()) {
            this.debugLogger.debug("[Tasks] - Launching report cache worker task...", new Object[0]);
            this.reportCacheWorker = new ReportCacheWorker(this, this.issuanceReportService, this.persistanceService);
            this.reportCacheWorker.start();
            this.debugLogger.debug("[Tasks] - Launching payments query task...", new Object[0]);
            this.paymentsQueryTask = new PaymentsQueryTask(this, this.easyPaymentsClient, this.lpEventDispatcher, this.issuanceReportService);
            this.paymentsQueryTask.start();
        }
        if (this.isPlayersSyncActive()) {
            this.debugLogger.debug("[Tasks] - Launching known players sync task...", new Object[0]);
            this.knownPlayersSyncTask = new KnownPlayersSyncTask(this, this.knownPlayersService, this.easyPaymentsClient);
            this.knownPlayersSyncTask.start();
        }
    }

    private void closeTasks() {
        CompletableFuture<Void> knownPlayersSyncTaskFuture = null;
        CompletableFuture<Void> paymentsQueryTaskFuture = null;
        CompletableFuture<Void> reportCacheWorkerFuture = null;
        if (this.knownPlayersSyncTask != null) {
            knownPlayersSyncTaskFuture = this.knownPlayersSyncTask.shutdownAsync();
        }
        if (this.paymentsQueryTask != null) {
            paymentsQueryTaskFuture = this.paymentsQueryTask.shutdownAsync();
        }
        if (this.reportCacheWorker != null) {
            reportCacheWorkerFuture = this.reportCacheWorker.shutdownAsync();
        }
        if (knownPlayersSyncTaskFuture != null || paymentsQueryTaskFuture != null || reportCacheWorkerFuture != null) {
            this.getLogger().info("Closing internal tasks...");
            this.debugLogger.info("Closing internal tasks...", new Object[0]);
            if (knownPlayersSyncTaskFuture != null) {
                knownPlayersSyncTaskFuture.join();
                this.knownPlayersSyncTask = null;
            }
            if (paymentsQueryTaskFuture != null) {
                paymentsQueryTaskFuture.join();
                this.paymentsQueryTask = null;
            }
            if (reportCacheWorkerFuture != null) {
                reportCacheWorkerFuture.join();
                this.reportCacheWorker = null;
            }
        }
    }

    private void reportException(@NotNull Throwable ex) {
        this.reportException(ex, null, new Object[0]);
    }

    private void reportException(@NotNull Throwable ex, @Nullable String message, Object ... args) {
        if (message != null) {
            this.error(message, args);
        }
        this.error(ex instanceof ConfigurationValidationException ? ex.getMessage() : ex.toString(), new Object[0]);
        this.error("Need a help? You can learn the documentation here:", new Object[0]);
        this.error("> %s", TROUBLESHOOTING_PAGE_URL);
    }

    private void disablePlugin() {
        this.error("Disabling plugin...", new Object[0]);
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
    }

    @NotNull
    private CompletableFuture<PluginStateModel> deferRemoteStateQuery() {
        if (!this.pluginConfigured) {
            return CompletableFuture.completedFuture(PluginStateModel.DEFAULT);
        }
        return CompletableFuture.supplyAsync(() -> {
            PluginStateModel pluginStateModel = PluginStateModel.DEFAULT;
            int receivedOnAttempt = 0;
            for (int attempt = 0; attempt < 5; ++attempt) {
                try {
                    pluginStateModel = this.easyPaymentsClient.getPluginState();
                    receivedOnAttempt = attempt;
                    break;
                }
                catch (Exception ex) {
                    if (attempt == 4) {
                        throw new RuntimeException(ex);
                    }
                    this.debugLogger.warn("Couldn't query remote state! ({0} of {1})", attempt + 1, 5);
                    this.debugLogger.warn(ex);
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ignored) {
                        return pluginStateModel;
                    }
                }
            }
            if (receivedOnAttempt > 0 && this.pluginConfigured) {
                this.getLogger().warning(String.format("Remote state has been received on attempt #%d! Ensure that your Internet connection is stable.", receivedOnAttempt + 1));
            }
            this.debugLogger.debug("[RemoteState] Model: {0}", pluginStateModel);
            return pluginStateModel;
        });
    }

    private void awaitRemoteStateQuery(@NotNull CompletableFuture<PluginStateModel> future) {
        try {
            this.pluginStateModel = future.join();
        }
        catch (Exception ex) {
            this.pluginStateModel = PluginStateModel.DEFAULT;
            Throwable cause = ex.getCause();
            while (cause instanceof ExecutionException || cause instanceof RuntimeException) {
                cause = cause.getCause();
            }
            this.debugLogger.error("[FATAL] Couldn't query remote state!", new Object[0]);
            if (cause != null) {
                this.debugLogger.error(cause);
            }
            if (!this.pluginConfigured) {
                return;
            }
            this.error("[FATAL] Couldn't query remote state! Please, check your Internet connection!", new Object[0]);
            this.error("[FATAL] Falling back to the default state! The plugin will not issue", new Object[0]);
            this.error("[FATAL] purchases or sync players until server restart or '/ep reload'.", new Object[0]);
        }
    }

    private void checkForUpdates() {
        String currentVersion = this.getDescription().getVersion();
        try {
            PluginVersionModel pluginVersionModel = this.easyPaymentsClient.getPluginVersion(currentVersion);
            this.debugLogger.debug("[CheckForUpdates] Model: {0}", pluginVersionModel);
            String downloadUrl = pluginVersionModel.getDownloadUrl();
            String version = pluginVersionModel.getVersion();
            if (downloadUrl != null && version != null) {
                this.pluginVersionModel = pluginVersionModel;
                this.debugLogger.info("[CheckForUpdates] Found new version {0}, current is {1}", version, currentVersion);
                this.info(" ", new Object[0]);
                this.info(" &rA new version of &eEasyPayments &ravailable!", new Object[0]);
                this.info(" &rYour version: &b%s&r, available version: &a%s", currentVersion, version);
                this.info(" &rDownload: &6%s", downloadUrl);
                this.info(" ", new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void info(@NotNull String message, Object ... args) {
        this.getLogger().info(AnsiColorizer.colorize(String.format(message, args)));
    }

    private void warn(@NotNull String message, Object ... args) {
        this.getLogger().warning(AnsiColorizer.colorize(String.format(message, args)));
    }

    private void error(@NotNull String message, Object ... args) {
        this.getLogger().severe(AnsiColorizer.colorize(String.format(message, args)));
    }

    @NotNull
    public DatabaseManager getStorage() {
        if (!EasyPaymentsPlugin.isPluginEnabled() || this.databaseManager == null) {
            throw new PluginUnavailableException();
        }
        return this.databaseManager;
    }

    @NotNull
    public Optional<PluginVersionModel> getPluginVersionModel() {
        return Optional.ofNullable(this.pluginVersionModel);
    }

    @Override
    public boolean areBothFeaturesInactive() {
        return !this.isPlayersSyncActive() && !this.isPurchasesIssuanceActive();
    }

    @Override
    public boolean isPlayersSyncActive() {
        return this.pluginEnabled() && this.pluginStateModel.isPlayersSyncActive();
    }

    @Override
    public boolean isPurchasesIssuanceActive() {
        return this.pluginEnabled() && this.pluginStateModel.isPurchaseIssuanceActive();
    }

    private boolean pluginEnabled() {
        return this.pluginEnabled;
    }

    private void changeEnabledState(boolean value) {
        this.pluginEnabled = value;
    }

    @NotNull
    public static String getVersion() {
        return instance.getDescription().getVersion();
    }

    public static boolean isPluginEnabled() {
        return instance.pluginEnabled();
    }

    public static boolean isStorageAvailable() {
        return EasyPaymentsPlugin.isPluginEnabled() && EasyPaymentsPlugin.instance.databaseManager != null;
    }

    @Override
    @Generated
    public DebugLogger getDebugLogger() {
        return this.debugLogger;
    }

    @Generated
    public Messages getMessages() {
        return this.messages;
    }

    @Generated
    public ShopCartConfig getShopCartConfig() {
        return this.shopCartConfig;
    }

    @Generated
    public PersistanceService getPersistanceService() {
        return this.persistanceService;
    }

    @Override
    @Generated
    public PlatformResolverState getPlatformResolverState() {
        return this.platformResolverState;
    }

    @Override
    @Generated
    public PlatformProvider getPlatformProvider() {
        return this.platformProvider;
    }

    @Generated
    public ShopCartStorage getShopCartStorage() {
        return this.shopCartStorage;
    }

    @Generated
    public ExecutionService getExecutionService() {
        return this.executionService;
    }

    @Generated
    public LongPollEventDispatcher getLpEventDispatcher() {
        return this.lpEventDispatcher;
    }

    @Generated
    public IssuanceReportService getIssuanceReportService() {
        return this.issuanceReportService;
    }

    @Generated
    public IssuancePerformService getIssuancePerformService() {
        return this.issuancePerformService;
    }

    @Generated
    public KnownPlayersService getKnownPlayersService() {
        return this.knownPlayersService;
    }

    @Override
    @Generated
    public RelativeTimeFormatter getRelativeTimeFormatter() {
        return this.relativeTimeFormatter;
    }

    @Override
    @Generated
    public String getAccessKey() {
        return this.accessKey;
    }

    @Override
    @Generated
    public int getServerId() {
        return this.serverId;
    }

    static {
        Logger.setGlobalLogLevel(Level.ERROR);
    }
}

