/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.core.easydonate4j.EventType;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventUpdateReport;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventUpdateReports;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.object.CommandReport;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.object.NewPaymentReport;
import ru.easydonate.easypayments.core.util.ThrowableCauseFinder;
import ru.easydonate.easypayments.database.model.Payment;
import ru.easydonate.easypayments.database.model.Purchase;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.exception.ApiResponseFailureException;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpRequestException;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpResponseException;
import ru.easydonate.easypayments.service.IssuanceReportService;
import ru.easydonate.easypayments.service.PersistanceService;
import ru.easydonate.easypayments.task.AbstractPluginTask;

public final class ReportCacheWorker
extends AbstractPluginTask {
    private static final long TASK_PERIOD = 6000L;
    private final IssuanceReportService reportService;
    private final PersistanceService persistanceService;

    public ReportCacheWorker(@NotNull EasyPaymentsPlugin plugin, @NotNull IssuanceReportService reportService, @NotNull PersistanceService persistanceService) {
        super(plugin, 20L);
        this.reportService = reportService;
        this.persistanceService = persistanceService;
    }

    @Override
    protected long getPeriod() {
        return 6000L;
    }

    @Override
    public void run() {
        if (!this.isWorking()) {
            return;
        }
        List<Payment> payments = null;
        DATABASE_QUERIES_LOCK.lock();
        try {
            if (this.isWorking()) {
                payments = this.persistanceService.findUnreportedPayments();
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
        finally {
            DATABASE_QUERIES_LOCK.unlock();
        }
        if (payments == null || payments.isEmpty()) {
            this.updateActivityState();
            return;
        }
        EventUpdateReports reports = new EventUpdateReports();
        EventUpdateReport report = new EventUpdateReport(EventType.NEW_PAYMENT);
        reports.add(report);
        payments.forEach(payment -> report.addObject(this.constructReport((Payment)payment)));
        try {
            this.reportService.uploadReports(reports);
            CompletableFuture[] futures = (CompletableFuture[])payments.stream().filter(Payment::markAsReported).map(this.persistanceService::savePayment).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(futures).join();
        }
        catch (ApiResponseFailureException ex) {
            this.warning("[ReportCache] Response from API: %s", ex.getMessage());
            this.plugin.getDebugLogger().warn("[ReportCache] Response from API: {0}", ex.getMessage());
        }
        catch (HttpRequestException | HttpResponseException ex) {
            Throwable lastCause = ThrowableCauseFinder.findLastCause(ex);
            if (lastCause instanceof IOException && lastCause.getMessage().contains("Server returned HTTP response code: 403")) {
                this.error("Access denied! Please, make sure that you are using a latest version!");
                this.plugin.getDebugLogger().error("[ReportCache] Unsupported EasyPayments version (403)", new Object[0]);
                this.updateActivityState();
                return;
            }
            this.error("[ReportCache] %s", ex.getMessage());
            this.plugin.getDebugLogger().error("[ReportCache] {0}", ex.getMessage());
            this.plugin.getDebugLogger().error(ex);
        }
        this.updateActivityState();
    }

    @NotNull
    private NewPaymentReport constructReport(@NotNull Payment payment) {
        ArrayList<CommandReport> commandReports = new ArrayList<CommandReport>();
        if (payment.hasPurchases()) {
            payment.getPurchases().stream().map(this::processPurchase).filter(Objects::nonNull).flatMap(Collection::stream).forEach(commandReports::add);
        }
        boolean addedToCart = commandReports.isEmpty();
        return new NewPaymentReport(payment.getId(), addedToCart, payment.getCustomer().getPlayerName(), commandReports);
    }

    @Nullable
    private List<CommandReport> processPurchase(@NotNull Purchase purchase) {
        return purchase.isCollected() ? purchase.constructCommandReports() : null;
    }
}

