/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.task;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.core.platform.scheduler.PlatformScheduler;
import ru.easydonate.easypayments.core.platform.scheduler.PlatformTask;
import ru.easydonate.easypayments.task.PluginTask;

public abstract class AbstractPluginTask
implements PluginTask,
Runnable {
    protected static final Lock DATABASE_QUERIES_LOCK = new ReentrantLock();
    protected final EasyPaymentsPlugin plugin;
    protected final long delay;
    protected PlatformTask asyncTask;
    protected boolean active = true;

    protected long getPeriod() {
        return -1L;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isWorking() {
        return this.asyncTask != null && !this.asyncTask.isCancelled(this.plugin.getPlatformProvider());
    }

    @Override
    public void start() {
        PlatformScheduler asyncScheduler = this.plugin.getPlatformProvider().getScheduler();
        long period = this.getPeriod();
        this.asyncTask = period >= 0L ? asyncScheduler.runAsyncAtFixedRate(this.plugin, this, this.delay, period) : asyncScheduler.runAsyncDelayed(this.plugin, this, this.delay);
    }

    @Override
    public void restart() {
        this.shutdown();
        this.start();
    }

    @Override
    public void shutdown() {
        if (this.asyncTask == null) {
            return;
        }
        this.asyncTask.cancel();
        while (this.isWorking() && this.isActive()) {
        }
        this.asyncTask = null;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> shutdownAsync() {
        return CompletableFuture.runAsync(this::shutdown);
    }

    protected synchronized void updateActivityState() {
        this.active = this.isWorking();
    }

    protected void warning(String message) {
        this.plugin.getLogger().warning(message);
    }

    protected void warning(String format, Object ... args) {
        this.warning(String.format(format, args));
    }

    protected void error(String message) {
        this.plugin.getLogger().severe(message);
    }

    protected void error(String format, Object ... args) {
        this.error(String.format(format, args));
    }

    @Generated
    protected AbstractPluginTask(EasyPaymentsPlugin plugin, long delay) {
        this.plugin = plugin;
        this.delay = delay;
    }
}

