/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.shopcart;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.database.DatabaseManager;
import ru.easydonate.easypayments.database.model.Customer;
import ru.easydonate.easypayments.exception.PluginUnavailableException;
import ru.easydonate.easypayments.shopcart.ShopCart;

public final class ShopCartStorage {
    private final EasyPaymentsPlugin plugin;
    private final Map<String, ShopCart> cachedShopCarts;

    public ShopCartStorage(@NotNull EasyPaymentsPlugin plugin) {
        this.plugin = plugin;
        this.cachedShopCarts = new ConcurrentHashMap<String, ShopCart>();
    }

    @NotNull
    public DatabaseManager getStorage() {
        return this.plugin.getStorage();
    }

    @NotNull
    public @UnmodifiableView Map<String, ShopCart> getCachedShopCarts() {
        return Collections.unmodifiableMap(this.cachedShopCarts);
    }

    @NotNull
    public ShopCart getShopCart(@NotNull OfflinePlayer bukkitPlayer) {
        return this.getShopCart(bukkitPlayer, bukkitPlayer.getName());
    }

    @NotNull
    public ShopCart getShopCart(@NotNull OfflinePlayer bukkitPlayer, @NotNull String playerName) {
        return this.getCached(bukkitPlayer.getName()).orElseGet(() -> this.loadAndCache(bukkitPlayer, playerName).join());
    }

    @NotNull
    public Optional<ShopCart> getCached(@NotNull String playerName) {
        return Optional.ofNullable(this.cachedShopCarts.get(playerName));
    }

    @NotNull
    public CompletableFuture<ShopCart> getAndCache(@NotNull String playerName) throws PluginUnavailableException {
        return this.plugin.getStorage().getCustomerByName(playerName).thenApply(customer -> {
            if (customer == null) {
                return null;
            }
            ShopCart shopCart = new ShopCart((Customer)customer);
            this.cachedShopCarts.put(playerName, shopCart);
            return shopCart;
        });
    }

    @NotNull
    public CompletableFuture<ShopCart> loadAndCache(@NotNull OfflinePlayer bukkitPlayer) throws PluginUnavailableException {
        return this.loadAndCache(bukkitPlayer, bukkitPlayer.getName());
    }

    @NotNull
    public CompletableFuture<ShopCart> loadAndCache(@NotNull OfflinePlayer bukkitPlayer, @NotNull String playerName) throws PluginUnavailableException {
        return this.plugin.getStorage().getOrCreateCustomer(bukkitPlayer, playerName).thenApply(customer -> {
            ShopCart shopCart = new ShopCart((Customer)customer);
            this.cachedShopCarts.put(playerName, shopCart);
            return shopCart;
        });
    }

    public void unloadCached(@NotNull String playerName) {
        this.cachedShopCarts.remove(playerName);
    }
}

