/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.setup.step.function;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.config.Configuration;
import ru.easydonate.easypayments.setup.InteractiveSetupProvider;
import ru.easydonate.easypayments.setup.ShortAnswer;
import ru.easydonate.easypayments.setup.session.InteractiveSetupSession;

public abstract class SetupStepFunction {
    protected final InteractiveSetupProvider setupProvider;

    public void onStepIn(@NotNull InteractiveSetupSession session) {
    }

    public void onStepOut(@NotNull InteractiveSetupSession session) {
    }

    public boolean validateInput(@NotNull InteractiveSetupSession session, @NotNull String rawInput) {
        return true;
    }

    public void onValidationFail(@NotNull InteractiveSetupSession session) {
    }

    public void applyInputValue(@NotNull InteractiveSetupSession session, @NotNull String rawInput) {
    }

    public void acceptShortAnswer(@NotNull InteractiveSetupSession session, @NotNull ShortAnswer answer) {
    }

    @NotNull
    protected Configuration config() {
        return this.setupProvider.getConfig();
    }

    protected void sendMessage(@NotNull InteractiveSetupSession session, @NotNull String key, Object ... replaces) {
        this.setupProvider.getMessages().getAndSend(session::sendMessage, key, replaces);
    }

    @Generated
    protected SetupStepFunction(InteractiveSetupProvider setupProvider) {
        this.setupProvider = setupProvider;
    }
}

