/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.setup.step.function;

import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.setup.InteractiveSetupProvider;
import ru.easydonate.easypayments.setup.ShortAnswer;
import ru.easydonate.easypayments.setup.session.InteractiveSetupSession;
import ru.easydonate.easypayments.setup.step.function.SetupStepFunction;

public final class ServerIdStepFunction
extends SetupStepFunction {
    public ServerIdStepFunction(@NotNull InteractiveSetupProvider setupProvider) {
        super(setupProvider);
    }

    @Override
    public void onStepIn(@NotNull InteractiveSetupSession session) {
        int currentValue = this.config().getInt("server-id", 0);
        if (currentValue > 0) {
            session.awaitShortAnswer();
            this.sendMessage(session, "setup.interactive.server-id.already-specified", "%server_id%", currentValue);
            return;
        }
        this.sendMessage(session, "setup.interactive.server-id.enter-new-value", new Object[0]);
    }

    @Override
    public void applyInputValue(@NotNull InteractiveSetupSession session, @NotNull String rawInput) {
        session.setServerId(Integer.parseInt(rawInput));
    }

    @Override
    public void acceptShortAnswer(@NotNull InteractiveSetupSession session, @NotNull ShortAnswer answer) {
        switch (answer) {
            case YES: {
                this.sendMessage(session, "setup.interactive.server-id.enter-new-value", new Object[0]);
                break;
            }
            case NO: {
                this.sendMessage(session, "setup.interactive.server-id.used-current-value", new Object[0]);
                this.setupProvider.nextSetupStep(session);
                break;
            }
        }
    }

    @Override
    public boolean validateInput(@NotNull InteractiveSetupSession session, @NotNull String rawInput) {
        try {
            int asInt = Integer.parseInt(rawInput);
            if (asInt > 0) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.sendMessage(session, "setup.failed.wrong-server-id", new Object[0]);
        return false;
    }

    @Override
    public void onValidationFail(@NotNull InteractiveSetupSession session) {
        this.sendMessage(session, "setup.interactive.server-id.enter-value-again", new Object[0]);
    }
}

