/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.setup.step.function;

import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.core.formatting.StringFormatter;
import ru.easydonate.easypayments.setup.InteractiveSetupProvider;
import ru.easydonate.easypayments.setup.ShortAnswer;
import ru.easydonate.easypayments.setup.session.InteractiveSetupSession;
import ru.easydonate.easypayments.setup.step.function.SetupStepFunction;

public final class AccessKeyStepFunction
extends SetupStepFunction {
    public AccessKeyStepFunction(@NotNull InteractiveSetupProvider setupProvider) {
        super(setupProvider);
    }

    @Override
    public void onStepIn(@NotNull InteractiveSetupSession session) {
        String currentValue = this.config().getString("key");
        if (currentValue != null && !currentValue.trim().isEmpty()) {
            session.awaitShortAnswer();
            String maskedKey = StringFormatter.maskAccessKey(currentValue);
            this.sendMessage(session, "setup.interactive.access-key.already-specified", "%access_key%", maskedKey);
            return;
        }
        this.sendMessage(session, "setup.interactive.access-key.enter-new-value", new Object[0]);
    }

    @Override
    public void applyInputValue(@NotNull InteractiveSetupSession session, @NotNull String rawInput) {
        session.setAccessKey(rawInput);
    }

    @Override
    public void acceptShortAnswer(@NotNull InteractiveSetupSession session, @NotNull ShortAnswer answer) {
        switch (answer) {
            case YES: {
                this.sendMessage(session, "setup.interactive.access-key.enter-new-value", new Object[0]);
                break;
            }
            case NO: {
                this.sendMessage(session, "setup.interactive.access-key.used-current-value", new Object[0]);
                this.setupProvider.nextSetupStep(session);
                break;
            }
        }
    }

    @Override
    public boolean validateInput(@NotNull InteractiveSetupSession session, @NotNull String rawInput) {
        if (rawInput == null || rawInput.length() != 32) {
            this.sendMessage(session, "setup.failed.wrong-key-length", new Object[0]);
            return false;
        }
        if (!EasyPaymentsPlugin.ACCESS_KEY_REGEX.matcher(rawInput.toLowerCase()).matches()) {
            this.sendMessage(session, "setup.failed.wrong-key-regex", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public void onValidationFail(@NotNull InteractiveSetupSession session) {
        this.sendMessage(session, "setup.interactive.access-key.enter-value-again", new Object[0]);
    }
}

