/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.setup.session;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.exception.UnsupportedCallerException;
import ru.easydonate.easypayments.setup.InteractiveSetupProvider;
import ru.easydonate.easypayments.setup.InteractiveSetupStep;
import ru.easydonate.easypayments.setup.ShortAnswer;
import ru.easydonate.easypayments.setup.session.ConsoleSetupSession;
import ru.easydonate.easypayments.setup.session.PlayerSetupSession;

public interface InteractiveSetupSession {
    public static final String ACCESS_KEY_PERSISTENT_KEY = "access-key";
    public static final String SERVER_ID_PERSISTENT_KEY = "server-id";

    @NotNull
    public static InteractiveSetupSession create(@NotNull InteractiveSetupProvider setupProvider, @NotNull CommandSender sender) throws UnsupportedCallerException {
        if (sender instanceof Player) {
            return new PlayerSetupSession(setupProvider, (Player)sender);
        }
        if (sender instanceof ConsoleCommandSender) {
            return new ConsoleSetupSession(setupProvider);
        }
        throw new UnsupportedCallerException();
    }

    public void initialize();

    @NotNull
    public CommandSender asBukkitSender();

    @NotNull
    public String getDisplayName();

    @NotNull
    public InteractiveSetupStep getCurrentStep();

    @NotNull
    public InteractiveSetupStep nextStep();

    public void awaitShortAnswer();

    public boolean isAwaitingShortAnswer();

    public void acceptShortAnswer(@NotNull ShortAnswer var1);

    public void sendMessage(@NotNull String var1);

    @NotNull
    public <T> Optional<T> getPersistentData(@NotNull String var1);

    @NotNull
    public <T> OptionalInt getPersistentIntData(@NotNull String var1);

    @NotNull
    public <T> OptionalLong getPersistentLongData(@NotNull String var1);

    @NotNull
    public <T> OptionalDouble getPersistentDoubleData(@NotNull String var1);

    public void savePersistentData(@NotNull String var1, @Nullable Object var2);

    @NotNull
    public Optional<String> getAccessKey();

    public void setAccessKey(@NotNull String var1);

    @NotNull
    public OptionalInt getServerId();

    public void setServerId(int var1);
}

