/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.setup.session;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.setup.InteractiveSetupProvider;
import ru.easydonate.easypayments.setup.InteractiveSetupStep;
import ru.easydonate.easypayments.setup.ShortAnswer;
import ru.easydonate.easypayments.setup.session.InteractiveSetupSession;

public abstract class AbstractSetupSession
implements InteractiveSetupSession {
    protected final InteractiveSetupProvider setupProvider;
    protected final Map<String, Object> persistentDataContainer;
    protected InteractiveSetupStep currentStep;
    private boolean awaitingShortAnswer;

    public AbstractSetupSession(@NotNull InteractiveSetupProvider setupProvider) {
        this.setupProvider = setupProvider;
        this.persistentDataContainer = new HashMap<String, Object>();
        this.currentStep = InteractiveSetupStep.START;
    }

    @Override
    public void initialize() {
        this.setupProvider.currentStepIn(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public InteractiveSetupStep getCurrentStep() {
        AbstractSetupSession abstractSetupSession = this;
        synchronized (abstractSetupSession) {
            return this.currentStep;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public InteractiveSetupStep nextStep() {
        AbstractSetupSession abstractSetupSession = this;
        synchronized (abstractSetupSession) {
            this.currentStep = this.currentStep.next();
            return this.currentStep;
        }
    }

    @Override
    public boolean isAwaitingShortAnswer() {
        return this.awaitingShortAnswer;
    }

    @Override
    public void acceptShortAnswer(@NotNull ShortAnswer answer) {
        this.awaitingShortAnswer = false;
        this.setupProvider.getCurrentStepFunction(this).acceptShortAnswer(this, answer);
    }

    @Override
    public void awaitShortAnswer() {
        this.awaitingShortAnswer = true;
    }

    @Override
    @NotNull
    public <T> Optional<T> getPersistentData(@NotNull String key) {
        return Optional.ofNullable(this.persistentDataContainer.get(key));
    }

    @Override
    @NotNull
    public <T> OptionalInt getPersistentIntData(@NotNull String key) {
        Integer value = (Integer)this.persistentDataContainer.get(key);
        return value != null ? OptionalInt.of(value) : OptionalInt.empty();
    }

    @Override
    @NotNull
    public <T> OptionalLong getPersistentLongData(@NotNull String key) {
        Long value = (Long)this.persistentDataContainer.get(key);
        return value != null ? OptionalLong.of(value) : OptionalLong.empty();
    }

    @Override
    @NotNull
    public <T> OptionalDouble getPersistentDoubleData(@NotNull String key) {
        Double value = (Double)this.persistentDataContainer.get(key);
        return value != null ? OptionalDouble.of(value) : OptionalDouble.empty();
    }

    @Override
    public synchronized void savePersistentData(@NotNull String key, @Nullable Object data) {
        this.persistentDataContainer.put(key, data);
    }

    @Override
    @NotNull
    public Optional<String> getAccessKey() {
        return this.getPersistentData("access-key");
    }

    @Override
    public void setAccessKey(@NotNull String accessKey) {
        this.savePersistentData("access-key", accessKey);
    }

    @Override
    @NotNull
    public OptionalInt getServerId() {
        return this.getPersistentIntData("server-id");
    }

    @Override
    public void setServerId(int serverId) {
        this.savePersistentData("server-id", serverId);
    }
}

