/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.setup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.core.config.Configuration;
import ru.easydonate.easypayments.core.config.localized.Messages;
import ru.easydonate.easypayments.core.formatting.StringFormatter;
import ru.easydonate.easypayments.exception.UnsupportedCallerException;
import ru.easydonate.easypayments.setup.InteractiveSetupStep;
import ru.easydonate.easypayments.setup.ShortAnswer;
import ru.easydonate.easypayments.setup.session.InteractiveSetupSession;
import ru.easydonate.easypayments.setup.step.function.AccessKeyStepFunction;
import ru.easydonate.easypayments.setup.step.function.FinishStepFunction;
import ru.easydonate.easypayments.setup.step.function.ServerIdStepFunction;
import ru.easydonate.easypayments.setup.step.function.SetupStepFunction;
import ru.easydonate.easypayments.setup.step.function.StartStepFunction;

public final class InteractiveSetupProvider {
    private static final List<String> ANSWERS_AGREE = Arrays.asList("yes", "y", "\u0434\u0430", "\u0434");
    private static final List<String> ANSWERS_REFUSE = Arrays.asList("no", "n", "\u043d\u0435\u0442", "\u043d");
    private static final List<String> ANSWERS_EXIT = Arrays.asList("exit", "quit", "q", "\u0432\u044b\u0439\u0442\u0438");
    private final EasyPaymentsPlugin plugin;
    private final Configuration config;
    private final Messages messages;
    private final Map<CommandSender, InteractiveSetupSession> sessions;
    private final Map<InteractiveSetupStep, SetupStepFunction> stepFunctions;

    public InteractiveSetupProvider(@NotNull EasyPaymentsPlugin plugin, @NotNull Configuration config, @NotNull Messages messages) {
        this.plugin = plugin;
        this.config = config;
        this.messages = messages;
        this.sessions = new HashMap<CommandSender, InteractiveSetupSession>();
        this.stepFunctions = new HashMap<InteractiveSetupStep, SetupStepFunction>();
        this.stepFunctions.put(InteractiveSetupStep.START, new StartStepFunction(this));
        this.stepFunctions.put(InteractiveSetupStep.SET_ACCESS_KEY, new AccessKeyStepFunction(this));
        this.stepFunctions.put(InteractiveSetupStep.SET_SERVER_ID, new ServerIdStepFunction(this));
        this.stepFunctions.put(InteractiveSetupStep.FINISH, new FinishStepFunction(this));
    }

    @NotNull
    public Configuration getConfig() {
        return this.config;
    }

    @NotNull
    public Messages getMessages() {
        return this.messages;
    }

    @NotNull
    public ShortAnswer defineShortAnswer(@NotNull String rawAnswer) {
        if (rawAnswer == null || rawAnswer.isEmpty()) {
            return ShortAnswer.UNDEFINED;
        }
        String answer = rawAnswer.trim();
        if (answer.isEmpty()) {
            return ShortAnswer.UNDEFINED;
        }
        if (ANSWERS_AGREE.stream().anyMatch(answer::equalsIgnoreCase)) {
            return ShortAnswer.YES;
        }
        if (ANSWERS_REFUSE.stream().anyMatch(answer::equalsIgnoreCase)) {
            return ShortAnswer.NO;
        }
        return ShortAnswer.UNDEFINED;
    }

    public synchronized void currentStepIn(@NotNull InteractiveSetupSession session) {
        this.getCurrentStepFunction(session).onStepIn(session);
    }

    public synchronized void currentStepOut(@NotNull InteractiveSetupSession session) {
        this.getCurrentStepFunction(session).onStepOut(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void nextSetupStep(@NotNull InteractiveSetupSession session) {
        Map<InteractiveSetupStep, SetupStepFunction> map = this.stepFunctions;
        synchronized (map) {
            this.currentStepOut(session);
            InteractiveSetupStep step = session.nextStep();
            if (step.isFinished()) {
                this.sessions.remove(session.asBukkitSender());
                ArrayList pendingFeedback = new ArrayList();
                session.getAccessKey().ifPresent(key -> {
                    this.config.getOverrides().put("key", key);
                    String maskedKey = StringFormatter.maskAccessKey(key);
                    pendingFeedback.add(() -> this.messages.getAndSend(session::sendMessage, "setup.success.access-key", "%access_key%", maskedKey));
                });
                session.getServerId().ifPresent(serverId -> {
                    this.config.getOverrides().put("server-id", serverId);
                    pendingFeedback.add(() -> this.messages.getAndSend(session::sendMessage, "setup.success.server-id", "%server_id%", serverId));
                });
                if (!pendingFeedback.isEmpty()) {
                    this.config.reload();
                    pendingFeedback.forEach(Runnable::run);
                    pendingFeedback.clear();
                }
                CompletableFuture.runAsync(() -> {
                    try {
                        this.plugin.reload();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            this.currentStepIn(session);
        }
    }

    @NotNull
    public SetupStepFunction getCurrentStepFunction(@NotNull InteractiveSetupSession session) {
        return this.stepFunctions.get((Object)session.getCurrentStep());
    }

    public boolean handleChatMessage(@NotNull CommandSender sender, @Nullable String message) {
        return this.getSession(sender).map(session -> this.handleChatMessage((InteractiveSetupSession)session, message)).orElse(false);
    }

    public boolean handleChatMessage(@NotNull InteractiveSetupSession session, @Nullable String message) {
        if (message == null || message.isEmpty()) {
            return false;
        }
        if (ANSWERS_EXIT.stream().anyMatch(message::equalsIgnoreCase)) {
            this.messages.getAndSend(session::sendMessage, "setup.exit", new Object[0]);
            this.closeSession(session.asBukkitSender());
            return true;
        }
        if (session.isAwaitingShortAnswer()) {
            ShortAnswer shortAnswer = this.defineShortAnswer(message);
            if (shortAnswer.isUndefined()) {
                this.messages.getAndSend(session::sendMessage, "setup.failed.wrong-short-answer", new Object[0]);
            } else {
                session.acceptShortAnswer(shortAnswer);
            }
            return true;
        }
        SetupStepFunction stepFunction = this.getCurrentStepFunction(session);
        boolean validated = stepFunction.validateInput(session, message);
        if (validated) {
            stepFunction.applyInputValue(session, message);
            this.nextSetupStep(session);
        } else {
            stepFunction.onValidationFail(session);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        Map<CommandSender, InteractiveSetupSession> map = this.sessions;
        synchronized (map) {
            this.sessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Optional<InteractiveSetupSession> closeSession(@NotNull CommandSender sender) {
        Map<CommandSender, InteractiveSetupSession> map = this.sessions;
        synchronized (map) {
            return Optional.ofNullable(this.sessions.remove(sender));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Optional<InteractiveSetupSession> getSession(@NotNull CommandSender sender) {
        Map<CommandSender, InteractiveSetupSession> map = this.sessions;
        synchronized (map) {
            return Optional.ofNullable(this.sessions.get(sender));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSession(@NotNull CommandSender sender) {
        Map<CommandSender, InteractiveSetupSession> map = this.sessions;
        synchronized (map) {
            return this.sessions.containsKey(sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public InteractiveSetupSession openSession(@NotNull CommandSender sender, boolean returnExisting) throws UnsupportedCallerException {
        Optional<InteractiveSetupSession> existingSession = this.getSession(sender);
        if (existingSession.isPresent() && returnExisting) {
            return existingSession.get();
        }
        Map<CommandSender, InteractiveSetupSession> map = this.sessions;
        synchronized (map) {
            InteractiveSetupSession session = InteractiveSetupSession.create(this, sender);
            session.initialize();
            this.sessions.put(sender, session);
            return session;
        }
    }
}

