/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.service.processor.update;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.easydonate4j.EventType;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventReportObject;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventUpdateReport;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.EventObject;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.EventUpdate;
import ru.easydonate.easypayments.core.exception.StructureValidationException;
import ru.easydonate.easypayments.service.LongPollEventDispatcher;
import ru.easydonate.easypayments.service.processor.update.EventUpdateProcessor;

public final class SimplePaymentEventProcessor<E extends EventObject, R extends EventReportObject>
implements EventUpdateProcessor<E, R> {
    private final LongPollEventDispatcher dispatcher;

    public SimplePaymentEventProcessor(@NotNull LongPollEventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    @NotNull
    public EventUpdateReport<R> processUpdate(@NotNull EventUpdate<E> eventUpdate) throws StructureValidationException {
        eventUpdate.validate();
        EventType eventType = eventUpdate.getEventType();
        List<E> eventObjects = eventUpdate.getEventObjects();
        EventUpdateReport report = eventUpdate.createReport();
        eventObjects.parallelStream().map(object -> this.dispatcher.processEventObject(eventType, object)).map(CompletableFuture::join).map(object -> object).forEach(report::addObject);
        return report;
    }
}

