/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.core.EasyPayments;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventUpdateReport;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.object.CommandReport;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.object.NewPaymentReport;
import ru.easydonate.easypayments.database.DatabaseManager;
import ru.easydonate.easypayments.database.model.Customer;
import ru.easydonate.easypayments.database.model.Payment;
import ru.easydonate.easypayments.database.model.Purchase;

public final class PersistanceService {
    private static final CompletableFuture<Void> COMPLETED_FUTURE = CompletableFuture.completedFuture(null);
    private final EasyPayments plugin;
    private final DatabaseManager databaseManager;

    public void persistPaymentsReportedState(@NotNull List<EventUpdateReport<?>> reports, @Nullable Predicate<Payment> collectedStateResolver) {
        Map<Integer, Payment> payments = this.findUnreportedPayments().stream().collect(Collectors.toMap(Payment::getId, p -> p));
        if (payments.isEmpty()) {
            this.plugin.getDebugLogger().debug("[Persistance] There are no unreported payments in the database", new Object[0]);
            return;
        }
        this.plugin.getDebugLogger().debug("[Persistance] Unreported payments in the database: {0}", payments.keySet());
        CompletableFuture[] futures = (CompletableFuture[])reports.stream().map(EventUpdateReport::getReportObjects).flatMap(Collection::stream).filter(object -> object instanceof NewPaymentReport).map(object -> (NewPaymentReport)object).map(NewPaymentReport::getPaymentId).map(payments::get).filter(Objects::nonNull).filter(Payment::markAsReported).peek(payment -> this.markAsCollectedIfNeeded((Payment)payment, collectedStateResolver)).map(this.databaseManager::savePayment).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures).join();
        this.plugin.getDebugLogger().debug("[Persistance] Unreported payments have been updated", new Object[0]);
    }

    public void populatePurchaseWithReportData(@NotNull Payment payment, int purchaseId, @NotNull List<CommandReport> reports) {
        ((CompletableFuture)this.databaseManager.getPurchase(purchaseId).thenCompose(purchase -> {
            if (purchase != null && purchase.collect(reports)) {
                return this.databaseManager.savePurchase((Purchase)purchase).thenCompose(v -> this.databaseManager.refreshPayment(payment));
            }
            return COMPLETED_FUTURE;
        })).join();
    }

    public List<Payment> findUnreportedPayments() {
        return this.databaseManager.getAllUnreportedPayments(this.plugin.getServerId()).join();
    }

    public CompletableFuture<?> refreshCustomer(@NotNull Customer customer) {
        return this.databaseManager.refreshCustomer(customer);
    }

    public CompletableFuture<?> savePayment(@NotNull Payment payment) {
        return this.databaseManager.savePayment(payment);
    }

    public CompletableFuture<?> savePurchase(@NotNull Purchase purchase) {
        return this.databaseManager.savePurchase(purchase);
    }

    private void markAsCollectedIfNeeded(Payment payment, Predicate<Payment> collectedStateResolver) {
        if (collectedStateResolver == null || collectedStateResolver.test(payment)) {
            payment.markAsCollected();
        }
    }

    @Generated
    public PersistanceService(EasyPayments plugin, DatabaseManager databaseManager) {
        this.plugin = plugin;
        this.databaseManager = databaseManager;
    }
}

