/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.service;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.core.EasyPayments;
import ru.easydonate.easypayments.core.easydonate4j.EventType;
import ru.easydonate.easypayments.core.easydonate4j.extension.client.EasyPaymentsClient;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventUpdateReport;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventUpdateReports;
import ru.easydonate.easypayments.database.model.Payment;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpRequestException;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpResponseException;
import ru.easydonate.easypayments.service.PersistanceService;

public final class IssuanceReportService {
    private final EasyPayments plugin;
    private final PersistanceService persistanceService;
    private final EasyPaymentsClient easyPaymentsClient;

    public void uploadReports(@NotNull List<EventUpdateReport<?>> reports) throws HttpRequestException, HttpResponseException {
        EventUpdateReports collection = new EventUpdateReports((Collection<? extends EventUpdateReport<?>>)reports);
        this.uploadReports(collection);
    }

    public void uploadReports(@NotNull EventUpdateReports reports) throws HttpRequestException, HttpResponseException {
        if (reports.isEmpty()) {
            return;
        }
        this.plugin.getDebugLogger().debug("[Issuance] Uploading reports:", new Object[0]);
        this.plugin.getDebugLogger().debug(reports.toPrettyString().split("\n"));
        if (this.easyPaymentsClient == null || !this.easyPaymentsClient.uploadReports(reports)) {
            this.plugin.getLogger().severe("An unknown error occured while trying to upload reports!");
            this.plugin.getLogger().severe("Please, contact with the platform support:");
            this.plugin.getLogger().severe("https://vk.me/easydonate");
            return;
        }
        this.plugin.getDebugLogger().debug("[Issuance] Reports have been uploaded", new Object[0]);
    }

    public void uploadReportsAndPersistStates(@NotNull List<EventUpdateReport<?>> reports, @Nullable Predicate<Payment> collectedStateResolver) throws HttpRequestException, HttpResponseException {
        EventUpdateReports collection = new EventUpdateReports((Collection<? extends EventUpdateReport<?>>)reports);
        this.uploadReportsAndPersistStates(collection, collectedStateResolver);
    }

    public void uploadReportsAndPersistStates(@NotNull EventUpdateReports reports, @Nullable Predicate<Payment> collectedStateResolver) throws HttpRequestException, HttpResponseException {
        if (reports.isEmpty()) {
            return;
        }
        this.uploadReports(reports);
        if (reports.containsReportWithType(EventType.NEW_PAYMENT)) {
            this.persistanceService.persistPaymentsReportedState(reports, collectedStateResolver);
        } else {
            this.plugin.getDebugLogger().debug("[Issuance] There are no 'new_payment' events, skipping persistance update...", new Object[0]);
        }
    }

    @Generated
    public IssuanceReportService(EasyPayments plugin, PersistanceService persistanceService, EasyPaymentsClient easyPaymentsClient) {
        this.plugin = plugin;
        this.persistanceService = persistanceService;
        this.easyPaymentsClient = easyPaymentsClient;
    }
}

