/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.core.EasyPayments;
import ru.easydonate.easypayments.core.easydonate4j.EventType;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventUpdateReport;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventUpdateReports;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.object.CommandReport;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.object.NewPaymentReport;
import ru.easydonate.easypayments.database.model.Payment;
import ru.easydonate.easypayments.database.model.Purchase;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpRequestException;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpResponseException;
import ru.easydonate.easypayments.service.IssuanceReportService;
import ru.easydonate.easypayments.service.PersistanceService;
import ru.easydonate.easypayments.service.execution.ExecutionService;

public final class IssuancePerformService {
    private final EasyPayments plugin;
    private final IssuanceReportService reportService;
    private final ExecutionService executionService;
    private final PersistanceService persistanceService;

    public void issuePurchasesAndReport(@NotNull Collection<Payment> payments) throws HttpRequestException, HttpResponseException {
        this.issuePurchasesAndReport(payments, null);
    }

    public void issuePurchasesAndReport(@NotNull Collection<Payment> payments, @Nullable Predicate<Purchase> purchaseFilter) throws HttpRequestException, HttpResponseException {
        List<NewPaymentReport> reports = this.issuePurchases(payments, purchaseFilter);
        if (reports.isEmpty()) {
            return;
        }
        EventUpdateReport<NewPaymentReport> updateReport = new EventUpdateReport<NewPaymentReport>(EventType.NEW_PAYMENT, reports);
        EventUpdateReports updateReports = new EventUpdateReports(updateReport);
        this.reportService.uploadReports(updateReports);
    }

    @NotNull
    public List<NewPaymentReport> issuePurchases(@NotNull Collection<Payment> payments) {
        return this.issuePurchases(payments, null);
    }

    @NotNull
    public List<NewPaymentReport> issuePurchases(@NotNull Collection<Payment> payments, @Nullable Predicate<Purchase> purchaseFilter) {
        if ((payments = this.excludeFullyNonMatched(payments, purchaseFilter)).isEmpty()) {
            return Collections.emptyList();
        }
        this.plugin.getDebugLogger().debug("[Issuance] Marking payments as collected...", new Object[0]);
        CompletableFuture[] futures = (CompletableFuture[])payments.stream().filter(payment -> this.hasAllPurchasesMatched((Payment)payment, p -> p.isCollected() || purchaseFilter == null || purchaseFilter.test((Purchase)p))).filter(Payment::markAsCollected).map(this.persistanceService::savePayment).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures).join();
        this.plugin.getDebugLogger().debug("[Issuance] {0} payment(s) have been marked as collected", futures.length);
        this.plugin.getDebugLogger().debug("[Issuance] Issuing purchases from {0} payment(s)...", payments.size());
        return payments.parallelStream().map(payment -> this.handlePayment((Payment)payment, purchaseFilter)).collect(Collectors.toList());
    }

    @NotNull
    private NewPaymentReport handlePayment(@NotNull Payment payment, @Nullable Predicate<Purchase> purchaseFilter) {
        String customer = payment.getCustomer().getPlayerName();
        NewPaymentReport report = new NewPaymentReport(payment.getId(), false, customer);
        if (payment.hasPurchases()) {
            payment.getPurchases().parallelStream().filter(purchase -> purchaseFilter == null || purchaseFilter.test((Purchase)purchase)).filter(Purchase::hasCommands).map(purchase -> this.handlePurchase(customer, (Purchase)purchase)).flatMap(Collection::stream).forEach(report::addCommandReport);
        }
        return report;
    }

    @NotNull
    private List<CommandReport> handlePurchase(String customer, @NotNull Purchase purchase) {
        List<String> commands = purchase.getCommands();
        if (commands != null && !commands.isEmpty()) {
            commands = commands.stream().map(command -> command != null ? command.replace("{user}", customer) : command).collect(Collectors.toList());
        }
        List<CommandReport> commandReports = this.executionService.processCommandsKeepSequence(commands);
        purchase.collect(commandReports);
        this.persistanceService.savePurchase(purchase).join();
        return commandReports;
    }

    @NotNull
    private Collection<Payment> excludeFullyNonMatched(@NotNull Collection<Payment> payments, @Nullable Predicate<Purchase> purchaseFilter) {
        if (payments.isEmpty() || purchaseFilter == null) {
            return payments;
        }
        return payments.stream().filter(payment -> !this.hasAllPurchasesNonMatched((Payment)payment, purchaseFilter)).collect(Collectors.toList());
    }

    private boolean hasAllPurchasesMatched(@NotNull Payment payment, @Nullable Predicate<Purchase> purchaseFilter) {
        if (purchaseFilter == null || !payment.hasPurchases()) {
            return true;
        }
        return payment.getPurchases().stream().allMatch(purchaseFilter);
    }

    private boolean hasAllPurchasesNonMatched(@NotNull Payment payment, @Nullable Predicate<Purchase> purchaseFilter) {
        if (purchaseFilter == null || !payment.hasPurchases()) {
            return true;
        }
        return payment.getPurchases().stream().noneMatch(purchaseFilter);
    }

    @Generated
    public IssuancePerformService(EasyPayments plugin, IssuanceReportService reportService, ExecutionService executionService, PersistanceService persistanceService) {
        this.plugin = plugin;
        this.reportService = reportService;
        this.executionService = executionService;
        this.persistanceService = persistanceService;
    }
}

