/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.platform.spigot.v1_10_R1;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.v1_10_R1.DedicatedServer;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_10_R1.CraftServer;
import org.bukkit.craftbukkit.v1_10_R1.scheduler.CraftTask;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.spigotmc.SpigotConfig;
import ru.easydonate.easypayments.core.EasyPayments;
import ru.easydonate.easypayments.core.interceptor.InterceptorFactory;
import ru.easydonate.easypayments.core.platform.provider.PlatformProviderBase;
import ru.easydonate.easypayments.core.platform.scheduler.PlatformScheduler;
import ru.easydonate.easypayments.core.util.Reflection;
import ru.easydonate.easypayments.platform.spigot.v1_10_R1.interceptor.PlatformInterceptorFactory;

public final class PlatformProvider
extends PlatformProviderBase {
    private static final Method getPeriod = Reflection.getDeclaredMethod(CraftTask.class, "getPeriod", new Class[0]);

    public PlatformProvider(@NotNull EasyPayments plugin, @NotNull PlatformScheduler scheduler, @NotNull String executorName, int permissionLevel) {
        super(plugin, scheduler, executorName, permissionLevel);
    }

    @Override
    @NotNull
    protected OfflinePlayer createOfflinePlayer(@NotNull String name) {
        UUID uuid = this.resolvePlayerUUID(name);
        GameProfile profile = new GameProfile(uuid, name);
        return ((CraftServer)this.plugin.getServer()).getOfflinePlayer(profile);
    }

    @Override
    @NotNull
    protected InterceptorFactory createInterceptorFactory(@NotNull String executorName, int permissionLevel) {
        return new PlatformInterceptorFactory(this, executorName, permissionLevel);
    }

    @Override
    public boolean isTaskCancelled(@NotNull BukkitTask bukkitTask) {
        try {
            return super.isTaskCancelled(bukkitTask);
        }
        catch (Throwable ignored) {
            if (bukkitTask instanceof CraftTask) {
                Optional result = Reflection.invokeMethod(getPeriod, bukkitTask, new Object[0]);
                return !result.isPresent() || (Long)result.get() == -2L;
            }
            throw new IllegalArgumentException("this bukkit task isn't a CraftTask instance! (" + bukkitTask.getClass() + ")");
        }
    }

    @NotNull
    private UUID resolvePlayerUUID(@NotNull String name) {
        GameProfile profile;
        DedicatedServer server = ((CraftServer)this.plugin.getServer()).getHandle().getServer();
        if ((server.getOnlineMode() || SpigotConfig.bungee) && (profile = server.getUserCache().getProfile(name)) != null) {
            return profile.getId();
        }
        return this.createOfflineUUID(name);
    }
}

