/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.listener;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.core.config.localized.Messages;
import ru.easydonate.easypayments.core.platform.scheduler.PlatformScheduler;
import ru.easydonate.easypayments.database.DatabaseManager;
import ru.easydonate.easypayments.database.model.Customer;
import ru.easydonate.easypayments.database.model.Payment;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpRequestException;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpResponseException;
import ru.easydonate.easypayments.service.KnownPlayersService;
import ru.easydonate.easypayments.shopcart.ShopCart;
import ru.easydonate.easypayments.shopcart.ShopCartStorage;

public final class PlayerJoinQuitListener
implements Listener {
    private final EasyPaymentsPlugin plugin;
    private final PlatformScheduler scheduler;
    private final Messages messages;
    private final ShopCartStorage shopCartStorage;
    private final KnownPlayersService knownPlayersService;

    public PlayerJoinQuitListener(@NotNull EasyPaymentsPlugin plugin, @NotNull Messages messages, @NotNull ShopCartStorage shopCartStorage, @NotNull KnownPlayersService knownPlayersService) {
        this.plugin = plugin;
        this.scheduler = plugin.getPlatformProvider().getScheduler();
        this.messages = messages;
        this.shopCartStorage = shopCartStorage;
        this.knownPlayersService = knownPlayersService;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        if (!EasyPaymentsPlugin.isPluginEnabled() || this.plugin.areBothFeaturesInactive()) {
            return;
        }
        Player player = event.getPlayer();
        this.scheduler.runAsyncNow(this.plugin, () -> {
            this.notifyAboutVersionUpdate(player);
            if (this.plugin.isPurchasesIssuanceActive()) {
                this.updateCustomerOwnership(player);
                ((CompletableFuture)this.shopCartStorage.loadAndCache((OfflinePlayer)player).thenAccept(shopCart -> this.issueOrNotifyAboutCartContent(player, (ShopCart)shopCart))).join();
            }
            if (this.plugin.isPlayersSyncActive()) {
                this.knownPlayersService.rememberJoinedPlayer(player);
            }
        });
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        if (!EasyPaymentsPlugin.isPluginEnabled() || !this.plugin.isPurchasesIssuanceActive()) {
            return;
        }
        Player player = event.getPlayer();
        this.shopCartStorage.unloadCached(player.getName());
    }

    private void issueOrNotifyAboutCartContent(@NotNull Player player, @NotNull ShopCart shopCart) {
        if (this.plugin.getShopCartConfig().shouldIssueWhenOnline()) {
            Collection<Payment> payments = shopCart.getContent();
            if (payments == null || payments.isEmpty()) {
                return;
            }
            try {
                this.plugin.getDebugLogger().info("Issuing purchases to {0}, because auto-issue is enabled...", player.getName());
                this.plugin.getIssuancePerformService().issuePurchasesAndReport(payments);
            }
            catch (HttpRequestException | HttpResponseException ex) {
                this.plugin.getLogger().severe("An unknown error occured while trying to upload reports!");
                this.plugin.getLogger().severe("Please, contact with the platform support:");
                this.plugin.getLogger().severe("https://vk.me/easydonate");
                this.plugin.getDebugLogger().error(ex);
            }
            catch (Throwable ex) {
                this.plugin.getDebugLogger().error("An unexpected error was occured!", new Object[0]);
                this.plugin.getDebugLogger().error(ex);
            }
        } else {
            this.notifyAboutCartContent(player, shopCart);
        }
    }

    private void notifyAboutCartContent(@NotNull Player player, @NotNull ShopCart shopCart) {
        if (!player.hasPermission("easypayments.notify.cart")) {
            return;
        }
        if (shopCart == null || shopCart.isEmpty()) {
            return;
        }
        this.messages.getAndSend((CommandSender)player, "cart-notification", new Object[0]);
    }

    private void notifyAboutVersionUpdate(@NotNull Player player) {
        if (!player.hasPermission("easypayments.notify.update")) {
            return;
        }
        this.plugin.getPluginVersionModel().ifPresent(response -> this.messages.getAndSend((CommandSender)player, "update-notification", "%current_version%", this.plugin.getDescription().getVersion(), "%available_version%", response.getVersion(), "%download_url%", response.getDownloadUrl()));
    }

    private void updateCustomerOwnership(@NotNull Player player) {
        DatabaseManager databaseManager = this.shopCartStorage.getStorage();
        Customer customer = databaseManager.getCustomer((OfflinePlayer)player).join();
        if (customer == null) {
            return;
        }
        if (databaseManager.isUuidIdentificationEnabled()) {
            if (!player.getName().equals(customer.getPlayerName())) {
                databaseManager.transferCustomerOwnership(customer, player.getName()).join();
            }
        } else if (!player.getUniqueId().equals(customer.getPlayerUUID())) {
            customer.updateUUID(player.getUniqueId());
            databaseManager.saveCustomer(customer).join();
        }
    }
}

