/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.ormlite.stmt.query;

import java.sql.SQLException;
import java.util.List;
import ru.easydonate.easypayments.libs.ormlite.db.DatabaseType;
import ru.easydonate.easypayments.libs.ormlite.stmt.ArgumentHolder;
import ru.easydonate.easypayments.libs.ormlite.stmt.query.Clause;
import ru.easydonate.easypayments.libs.ormlite.stmt.query.NeedsFutureClause;

public class ManyClause
implements Clause,
NeedsFutureClause {
    private final Clause first;
    private Clause second;
    private final Clause[] others;
    private final int startOthersAt;
    private final Operation operation;

    public ManyClause(Clause first, Operation operation) {
        this.first = first;
        this.second = null;
        this.others = null;
        this.startOthersAt = 0;
        this.operation = operation;
    }

    public ManyClause(Clause first, Clause second, Clause[] others, Operation operation) {
        this.first = first;
        this.second = second;
        this.others = others;
        this.startOthersAt = 0;
        this.operation = operation;
    }

    public ManyClause(Clause[] others, Operation operation) {
        this.first = others[0];
        if (others.length < 2) {
            this.second = null;
            this.startOthersAt = others.length;
        } else {
            this.second = others[1];
            this.startOthersAt = 2;
        }
        this.others = others;
        this.operation = operation;
    }

    @Override
    public void appendSql(DatabaseType databaseType, String tableName, StringBuilder sb, List<ArgumentHolder> selectArgList, Clause outer) throws SQLException {
        boolean outerSame;
        boolean bl = outerSame = outer instanceof ManyClause && ((ManyClause)outer).operation == this.operation;
        if (!outerSame) {
            sb.append('(');
        }
        this.first.appendSql(databaseType, tableName, sb, selectArgList, this);
        if (this.second != null) {
            sb.append(this.operation.sql);
            sb.append(' ');
            this.second.appendSql(databaseType, tableName, sb, selectArgList, this);
        }
        if (this.others != null) {
            for (int i = this.startOthersAt; i < this.others.length; ++i) {
                sb.append(this.operation.sql);
                sb.append(' ');
                this.others[i].appendSql(databaseType, tableName, sb, selectArgList, this);
            }
        }
        if (!outerSame) {
            int len = sb.length();
            if (len > 0 && sb.charAt(len - 1) == ' ') {
                sb.setLength(len - 1);
            }
            sb.append(") ");
        }
    }

    @Override
    public void setMissingClause(Clause right) {
        this.second = right;
    }

    public static enum Operation {
        AND("AND"),
        OR("OR");

        public final String sql;

        private Operation(String sql) {
            this.sql = sql;
        }
    }
}

