/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.ormlite.stmt.mapped;

import java.sql.SQLException;
import ru.easydonate.easypayments.libs.ormlite.dao.Dao;
import ru.easydonate.easypayments.libs.ormlite.dao.ObjectCache;
import ru.easydonate.easypayments.libs.ormlite.db.DatabaseType;
import ru.easydonate.easypayments.libs.ormlite.field.FieldType;
import ru.easydonate.easypayments.libs.ormlite.stmt.mapped.BaseMappedStatement;
import ru.easydonate.easypayments.libs.ormlite.support.DatabaseConnection;
import ru.easydonate.easypayments.libs.ormlite.table.TableInfo;

public class MappedDelete<T, ID>
extends BaseMappedStatement<T, ID> {
    private MappedDelete(Dao<T, ID> dao, TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes) {
        super(dao, tableInfo, statement, argFieldTypes);
    }

    public static <T, ID> MappedDelete<T, ID> build(Dao<T, ID> dao, TableInfo<T, ID> tableInfo) throws SQLException {
        FieldType idField = tableInfo.getIdField();
        if (idField == null) {
            throw new SQLException("Cannot delete from " + tableInfo.getDataClass() + " because it doesn't have an id field");
        }
        StringBuilder sb = new StringBuilder(64);
        DatabaseType databaseType = dao.getConnectionSource().getDatabaseType();
        MappedDelete.appendTableName(databaseType, sb, "DELETE FROM ", tableInfo);
        MappedDelete.appendWhereFieldEq(databaseType, idField, sb, null);
        return new MappedDelete<T, ID>(dao, tableInfo, sb.toString(), new FieldType[]{idField});
    }

    public int delete(DatabaseConnection databaseConnection, T data, ObjectCache objectCache) throws SQLException {
        try {
            Object[] args = this.getFieldObjects(data);
            int rowC = databaseConnection.delete(this.statement, args, this.argFieldTypes);
            logger.debug("delete data with statement '{}' and {} args, changed {} rows", (Object)this.statement, (Object)args.length, (Object)rowC);
            if (args.length > 0) {
                logger.trace("delete arguments: {}", (Object)args);
            }
            if (rowC > 0 && objectCache != null) {
                Object id = this.idField.extractJavaFieldToSqlArgValue(data);
                objectCache.remove(this.clazz, id);
            }
            return rowC;
        }
        catch (SQLException e) {
            throw new SQLException("Unable to run delete stmt on object " + data + ": " + this.statement, e);
        }
    }

    public int deleteById(DatabaseConnection databaseConnection, ID id, ObjectCache objectCache) throws SQLException {
        try {
            Object[] args = new Object[]{this.convertIdToFieldObject(id)};
            int rowC = databaseConnection.delete(this.statement, args, this.argFieldTypes);
            logger.debug("delete data with statement '{}' and {} args, changed {} rows", (Object)this.statement, (Object)args.length, (Object)rowC);
            if (args.length > 0) {
                logger.trace("delete arguments: {}", (Object)args);
            }
            if (rowC > 0 && objectCache != null) {
                objectCache.remove(this.clazz, id);
            }
            return rowC;
        }
        catch (SQLException e) {
            throw new SQLException("Unable to run deleteById stmt on id " + id + ": " + this.statement, e);
        }
    }
}

