/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.ormlite.misc;

import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import ru.easydonate.easypayments.libs.ormlite.db.DatabaseType;
import ru.easydonate.easypayments.libs.ormlite.logger.Logger;
import ru.easydonate.easypayments.libs.ormlite.logger.LoggerFactory;
import ru.easydonate.easypayments.libs.ormlite.support.ConnectionSource;
import ru.easydonate.easypayments.libs.ormlite.support.DatabaseConnection;

public class TransactionManager {
    private static final Logger logger = LoggerFactory.getLogger(TransactionManager.class);
    private static final String SAVE_POINT_PREFIX = "ORMLITE";
    private ConnectionSource connectionSource;
    private static final AtomicInteger savePointCounter = new AtomicInteger();
    private static final ThreadLocal<TransactionLevel> transactionLevelThreadLocal = new ThreadLocal<TransactionLevel>(){

        @Override
        protected TransactionLevel initialValue() {
            return new TransactionLevel();
        }
    };

    public TransactionManager() {
    }

    public TransactionManager(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
        this.initialize();
    }

    public void initialize() {
        if (this.connectionSource == null) {
            throw new IllegalStateException("dataSource was not set on " + this.getClass().getSimpleName());
        }
    }

    public <T> T callInTransaction(Callable<T> callable) throws SQLException {
        return TransactionManager.callInTransaction(this.connectionSource, callable);
    }

    public <T> T callInTransaction(String tableName, Callable<T> callable) throws SQLException {
        return TransactionManager.callInTransaction(tableName, this.connectionSource, callable);
    }

    public static <T> T callInTransaction(ConnectionSource connectionSource, Callable<T> callable) throws SQLException {
        return TransactionManager.callInTransaction(null, connectionSource, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T callInTransaction(String tableName, ConnectionSource connectionSource, Callable<T> callable) throws SQLException {
        DatabaseConnection connection = connectionSource.getReadWriteConnection(tableName);
        boolean saved = false;
        try {
            saved = connectionSource.saveSpecialConnection(connection);
            T t = TransactionManager.callInTransaction(connection, saved, connectionSource.getDatabaseType(), callable);
            return t;
        }
        finally {
            if (saved) {
                connectionSource.clearSpecialConnection(connection);
            }
            connectionSource.releaseConnection(connection);
        }
    }

    public static <T> T callInTransaction(DatabaseConnection connection, DatabaseType databaseType, Callable<T> callable) throws SQLException {
        return TransactionManager.callInTransaction(connection, false, databaseType, callable);
    }

    public static <T> T callInTransaction(DatabaseConnection connection, boolean saved, DatabaseType databaseType, Callable<T> callable) throws SQLException {
        boolean restoreAutoCommit = false;
        TransactionLevel levelCount = transactionLevelThreadLocal.get();
        try {
            T t;
            boolean hasSavePoint = false;
            Savepoint savePoint = null;
            if (saved || databaseType.isNestedSavePointsSupported()) {
                if (connection.isAutoCommitSupported() && connection.isAutoCommit()) {
                    connection.setAutoCommit(false);
                    restoreAutoCommit = true;
                    logger.trace("had to set auto-commit to false");
                }
                if ((savePoint = connection.setSavePoint(SAVE_POINT_PREFIX + savePointCounter.incrementAndGet())) == null) {
                    logger.trace("started savePoint transaction");
                } else {
                    logger.trace("started savePoint transaction {}", (Object)savePoint.getSavepointName());
                }
                hasSavePoint = true;
            }
            try {
                levelCount.incrementAndGet();
                T result = callable.call();
                int level = levelCount.decrementAndGet();
                levelCount = null;
                if (level <= 0) {
                    transactionLevelThreadLocal.remove();
                }
                if (hasSavePoint) {
                    if (level <= 0) {
                        TransactionManager.commit(connection, savePoint);
                    } else {
                        TransactionManager.release(connection, savePoint);
                    }
                }
                t = result;
            }
            catch (Exception e) {
                if (levelCount != null && levelCount.decrementAndGet() <= 0) {
                    transactionLevelThreadLocal.remove();
                }
                if (hasSavePoint) {
                    try {
                        TransactionManager.rollBack(connection, savePoint);
                    }
                    catch (SQLException e2) {
                        logger.error(e, "after commit exception, rolling back to save-point also threw exception");
                    }
                }
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new SQLException("Transaction callable threw non-SQL exception", e);
            }
            return t;
        }
        finally {
            if (restoreAutoCommit) {
                connection.setAutoCommit(true);
                logger.trace("restored auto-commit to true");
            }
        }
    }

    public void setConnectionSource(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
    }

    private static void commit(DatabaseConnection connection, Savepoint savePoint) throws SQLException {
        String name = savePoint == null ? null : savePoint.getSavepointName();
        connection.commit(savePoint);
        if (name == null) {
            logger.trace("committed savePoint transaction");
        } else {
            logger.trace("committed savePoint transaction {}", (Object)name);
        }
    }

    private static void release(DatabaseConnection connection, Savepoint savePoint) throws SQLException {
        String name = savePoint == null ? null : savePoint.getSavepointName();
        connection.releaseSavePoint(savePoint);
        if (name == null) {
            logger.trace("released savePoint transaction");
        } else {
            logger.trace("released savePoint transaction {}", (Object)name);
        }
    }

    private static void rollBack(DatabaseConnection connection, Savepoint savePoint) throws SQLException {
        String name = savePoint == null ? null : savePoint.getSavepointName();
        connection.rollback(savePoint);
        if (name == null) {
            logger.trace("rolled back savePoint transaction");
        } else {
            logger.trace("rolled back savePoint transaction {}", (Object)name);
        }
    }

    private static class TransactionLevel {
        int counter;

        private TransactionLevel() {
        }

        int incrementAndGet() {
            return ++this.counter;
        }

        int decrementAndGet() {
            return --this.counter;
        }
    }
}

