/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.ormlite.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import ru.easydonate.easypayments.libs.ormlite.dao.ObjectCache;
import ru.easydonate.easypayments.libs.ormlite.field.FieldType;
import ru.easydonate.easypayments.libs.ormlite.jdbc.JdbcCompiledStatement;
import ru.easydonate.easypayments.libs.ormlite.jdbc.JdbcDatabaseResults;
import ru.easydonate.easypayments.libs.ormlite.jdbc.TypeValMapper;
import ru.easydonate.easypayments.libs.ormlite.logger.Logger;
import ru.easydonate.easypayments.libs.ormlite.logger.LoggerFactory;
import ru.easydonate.easypayments.libs.ormlite.misc.IOUtils;
import ru.easydonate.easypayments.libs.ormlite.stmt.GenericRowMapper;
import ru.easydonate.easypayments.libs.ormlite.stmt.StatementBuilder;
import ru.easydonate.easypayments.libs.ormlite.support.CompiledStatement;
import ru.easydonate.easypayments.libs.ormlite.support.DatabaseConnection;
import ru.easydonate.easypayments.libs.ormlite.support.DatabaseResults;
import ru.easydonate.easypayments.libs.ormlite.support.GeneratedKeyHolder;

public class JdbcDatabaseConnection
implements DatabaseConnection {
    private static Logger logger = LoggerFactory.getLogger(JdbcDatabaseConnection.class);
    private static final String JDBC_META_TABLE_NAME_COLUMN = "TABLE_NAME";
    private static Object[] noArgs = new Object[0];
    private static FieldType[] noArgTypes = new FieldType[0];
    private static GenericRowMapper<Long> longWrapper = new OneLongWrapper();
    private Connection connection;
    private Boolean supportsSavePoints;

    public JdbcDatabaseConnection(Connection connection) {
        this.connection = connection;
        logger.trace("connection opened: {}", connection);
    }

    @Override
    public boolean isAutoCommitSupported() {
        return true;
    }

    @Override
    public boolean isAutoCommit() throws SQLException {
        boolean autoCommit = this.connection.getAutoCommit();
        logger.trace("connection autoCommit is {}", autoCommit);
        return autoCommit;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
        logger.trace("connection set autoCommit to {}", autoCommit);
    }

    @Override
    public Savepoint setSavePoint(String name) throws SQLException {
        if (this.supportsSavePoints == null) {
            DatabaseMetaData metaData = this.connection.getMetaData();
            this.supportsSavePoints = metaData.supportsSavepoints();
            logger.trace("connection supports save points is {}", this.supportsSavePoints);
        }
        if (this.supportsSavePoints.booleanValue()) {
            Savepoint savepoint = this.connection.setSavepoint(name);
            logger.trace("save-point {} set with name {}", savepoint, (Object)name);
            return savepoint;
        }
        return null;
    }

    @Override
    public void commit(Savepoint savepoint) throws SQLException {
        if (savepoint == null) {
            this.connection.commit();
            logger.trace("connection committed");
        } else {
            Object nameOrSavepoint = savepoint.getSavepointName();
            if (nameOrSavepoint == null) {
                nameOrSavepoint = savepoint;
            }
            this.connection.commit();
            logger.trace("connection is committed for save-point {}", nameOrSavepoint);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (savepoint == null) {
            this.connection.rollback();
            logger.trace("connection is rolled back");
        } else {
            Object obj = savepoint.getSavepointName();
            if (obj == null) {
                obj = savepoint;
            }
            this.connection.rollback(savepoint);
            logger.trace("save-point {} is rolled back", obj);
        }
    }

    @Override
    public void releaseSavePoint(Savepoint savePoint) throws SQLException {
        if (savePoint == null) {
            logger.trace("release of null savepoint ignored");
        } else {
            this.connection.releaseSavepoint(savePoint);
        }
    }

    @Override
    public int executeStatement(String statementStr, int resultFlags) throws SQLException {
        if (resultFlags == -1) {
            resultFlags = 1003;
        }
        Statement statement = this.connection.createStatement(resultFlags, 1007);
        statement.execute(statementStr);
        return statement.getUpdateCount();
    }

    @Override
    public CompiledStatement compileStatement(String statement, StatementBuilder.StatementType type, FieldType[] argFieldTypes, int resultFlags, boolean cacheStore) throws SQLException {
        if (resultFlags == -1) {
            resultFlags = 1003;
        }
        JdbcCompiledStatement compiledStatement = new JdbcCompiledStatement(this.connection.prepareStatement(statement, resultFlags, 1007), statement, type, cacheStore);
        logger.trace("compiled statement: {}", (Object)statement);
        return compiledStatement;
    }

    @Override
    public void close() throws Exception {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new SQLException("could not close SQL connection", e);
        }
        logger.trace("connection closed: {}", this.connection);
    }

    @Override
    public void closeQuietly() {
        IOUtils.closeQuietly(this);
    }

    @Override
    public boolean isClosed() throws SQLException {
        boolean isClosed = this.connection.isClosed();
        logger.trace("connection is closed returned {}", isClosed);
        return isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insert(String statement, Object[] args, FieldType[] argFieldTypes, GeneratedKeyHolder keyHolder) throws SQLException {
        try (PreparedStatement stmt = keyHolder == null ? this.connection.prepareStatement(statement) : this.connection.prepareStatement(statement, new String[]{keyHolder.getColumnName()});){
            this.statementSetArgs(stmt, args, argFieldTypes);
            int rowN = stmt.executeUpdate();
            logger.trace("insert statement is prepared and executed: {}", (Object)statement);
            if (keyHolder != null) {
                ResultSet resultSet = stmt.getGeneratedKeys();
                ResultSetMetaData metaData = resultSet.getMetaData();
                int colN = metaData.getColumnCount();
                boolean wasSet = false;
                while (resultSet.next()) {
                    for (int colC = 1; colC <= colN; ++colC) {
                        Number id = this.getIdColumnData(resultSet, metaData, colC);
                        keyHolder.addKey(id);
                        wasSet = true;
                    }
                }
                if (!wasSet) {
                    throw new SQLException("no generated-keys were returned from statement, maybe a schema mismatch between entity and database table?: " + statement);
                }
            }
            int n = rowN;
            return n;
        }
    }

    @Override
    public int update(String statement, Object[] args, FieldType[] argFieldTypes) throws SQLException {
        return this.update(statement, args, argFieldTypes, "update");
    }

    @Override
    public int delete(String statement, Object[] args, FieldType[] argFieldTypes) throws SQLException {
        return this.update(statement, args, argFieldTypes, "delete");
    }

    @Override
    public <T> Object queryForOne(String statement, Object[] args, FieldType[] argFieldTypes, GenericRowMapper<T> rowMapper, ObjectCache objectCache) throws SQLException {
        return this.queryForOne(statement, args, argFieldTypes, rowMapper, objectCache, "query for one");
    }

    @Override
    public long queryForLong(String statement) throws SQLException {
        return this.queryForLong(statement, noArgs, noArgTypes);
    }

    @Override
    public long queryForLong(String statement, Object[] args, FieldType[] argFieldTypes) throws SQLException {
        Object result = this.queryForOne(statement, args, argFieldTypes, longWrapper, null, "query for long");
        if (result == null) {
            throw new SQLException("No results returned in query-for-long: " + statement);
        }
        if (result == MORE_THAN_ONE) {
            throw new SQLException("More than 1 result returned in query-for-long: " + statement);
        }
        return (Long)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTableExists(String tableName) throws SQLException {
        DatabaseMetaData metaData = this.connection.getMetaData();
        logger.trace("Got meta data from connection");
        try (ResultSet results = null;){
            results = metaData.getTables(null, null, "%", new String[]{"TABLE"});
            if (!results.next()) {
                boolean bl = false;
                return bl;
            }
            int col = results.findColumn(JDBC_META_TABLE_NAME_COLUMN);
            do {
                String dbTableName;
                if (!tableName.equalsIgnoreCase(dbTableName = results.getString(col))) continue;
                boolean bl = true;
                return bl;
            } while (results.next());
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public Connection getUnderlyingConnection() {
        return this.connection;
    }

    @Deprecated
    public void setInternalConnection(Connection connection) {
        this.connection = connection;
    }

    public void setUnderlyingConnection(Connection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int update(String statement, Object[] args, FieldType[] argFieldTypes, String label) throws SQLException {
        try (PreparedStatement stmt = this.connection.prepareStatement(statement);){
            this.statementSetArgs(stmt, args, argFieldTypes);
            int rowCount = stmt.executeUpdate();
            logger.trace("{} statement is prepared and executed returning {}: {}", (Object)label, (Object)rowCount, (Object)statement);
            int n = rowCount;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Object queryForOne(String statement, Object[] args, FieldType[] argFieldTypes, GenericRowMapper<T> rowMapper, ObjectCache objectCache, String label) throws SQLException {
        T first;
        JdbcDatabaseResults results;
        PreparedStatement stmt;
        block5: {
            block4: {
                Object var9_9;
                stmt = this.connection.prepareStatement(statement, 1003, 1007);
                results = null;
                try {
                    this.statementSetArgs(stmt, args, argFieldTypes);
                    results = new JdbcDatabaseResults(stmt, stmt.executeQuery(), objectCache, true);
                    logger.trace("{} statement is prepared and executed: {}", (Object)label, (Object)statement);
                    if (results.first()) break block4;
                    var9_9 = null;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(results);
                    stmt.close();
                    throw throwable;
                }
                IOUtils.closeQuietly(results);
                stmt.close();
                return var9_9;
            }
            first = rowMapper.mapRow(results);
            if (!results.next()) break block5;
            Object object = MORE_THAN_ONE;
            IOUtils.closeQuietly(results);
            stmt.close();
            return object;
        }
        T t = first;
        IOUtils.closeQuietly(results);
        stmt.close();
        return t;
    }

    private Number getIdColumnData(ResultSet resultSet, ResultSetMetaData metaData, int columnIndex) throws SQLException {
        int typeVal = metaData.getColumnType(columnIndex);
        switch (typeVal) {
            case -5: 
            case 2: 
            case 3: {
                return resultSet.getLong(columnIndex);
            }
            case 4: {
                return resultSet.getInt(columnIndex);
            }
        }
        String columnName = metaData.getColumnName(columnIndex);
        throw new SQLException("Unexpected ID column type " + (Object)((Object)TypeValMapper.getSqlTypeForTypeVal(typeVal)) + " (typeVal " + typeVal + ") in column " + columnName + "(#" + columnIndex + ") is not a number");
    }

    private void statementSetArgs(PreparedStatement stmt, Object[] args, FieldType[] argFieldTypes) throws SQLException {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            int typeVal = TypeValMapper.getTypeValForSqlType(argFieldTypes[i].getSqlType());
            if (arg == null) {
                stmt.setNull(i + 1, typeVal);
                continue;
            }
            stmt.setObject(i + 1, arg, typeVal);
        }
    }

    private static class OneLongWrapper
    implements GenericRowMapper<Long> {
        private OneLongWrapper() {
        }

        @Override
        public Long mapRow(DatabaseResults rs) throws SQLException {
            return rs.getLong(0);
        }
    }
}

