/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.ormlite.field.types;

import java.sql.SQLException;
import ru.easydonate.easypayments.libs.ormlite.field.FieldType;
import ru.easydonate.easypayments.libs.ormlite.field.SqlType;
import ru.easydonate.easypayments.libs.ormlite.field.types.BaseDataType;
import ru.easydonate.easypayments.libs.ormlite.support.DatabaseResults;

public class ShortObjectType
extends BaseDataType {
    private static final ShortObjectType singleTon = new ShortObjectType();

    public static ShortObjectType getSingleton() {
        return singleTon;
    }

    private ShortObjectType() {
        super(SqlType.SHORT, new Class[]{Short.class});
    }

    protected ShortObjectType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) {
        return Short.parseShort(defaultStr);
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getShort(columnPos);
    }

    @Override
    public Object convertIdNumber(Number number) {
        return number.shortValue();
    }

    @Override
    public boolean isEscapedValue() {
        return false;
    }

    @Override
    public boolean isValidForVersion() {
        return true;
    }

    @Override
    public Object moveToNextValue(Object currentValue) {
        if (currentValue == null) {
            return (short)1;
        }
        return (short)((Short)currentValue + 1);
    }
}

