/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.ormlite.field.types;

import java.sql.SQLException;
import ru.easydonate.easypayments.libs.ormlite.field.FieldType;
import ru.easydonate.easypayments.libs.ormlite.field.SqlType;
import ru.easydonate.easypayments.libs.ormlite.field.types.BaseDataType;
import ru.easydonate.easypayments.libs.ormlite.support.DatabaseResults;

public class FloatObjectType
extends BaseDataType {
    private static final FloatObjectType singleTon = new FloatObjectType();

    public static FloatObjectType getSingleton() {
        return singleTon;
    }

    private FloatObjectType() {
        super(SqlType.FLOAT, new Class[]{Float.class});
    }

    protected FloatObjectType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return Float.valueOf(results.getFloat(columnPos));
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) {
        return Float.valueOf(Float.parseFloat(defaultStr));
    }

    @Override
    public boolean isEscapedValue() {
        return false;
    }
}

