/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.ormlite.field.types;

import java.sql.SQLException;
import java.util.Currency;
import ru.easydonate.easypayments.libs.ormlite.field.FieldType;
import ru.easydonate.easypayments.libs.ormlite.field.SqlType;
import ru.easydonate.easypayments.libs.ormlite.field.types.BaseDataType;
import ru.easydonate.easypayments.libs.ormlite.support.DatabaseResults;

public class CurrencyType
extends BaseDataType {
    public static int DEFAULT_WIDTH = 30;
    private static final CurrencyType singleTon = new CurrencyType();

    public static CurrencyType getSingleton() {
        return singleTon;
    }

    public CurrencyType() {
        super(SqlType.STRING, new Class[]{Currency.class});
    }

    public CurrencyType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public int getDefaultWidth() {
        return DEFAULT_WIDTH;
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object javaObject) {
        Currency currency = (Currency)javaObject;
        return currency.getCurrencyCode();
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        try {
            return Currency.getInstance(defaultStr).getCurrencyCode();
        }
        catch (IllegalArgumentException iae) {
            throw new SQLException("Problems with field " + fieldType + " parsing default Currency '", iae);
        }
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getString(columnPos);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
        String currencyStr = (String)sqlArg;
        try {
            return Currency.getInstance(currencyStr);
        }
        catch (IllegalArgumentException iae) {
            throw new SQLException("Problems with column " + columnPos + " parsing Currency '" + currencyStr + "'", iae);
        }
    }

    @Override
    public boolean isAppropriateId() {
        return false;
    }
}

