/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.ormlite.field.types;

import java.sql.SQLException;
import ru.easydonate.easypayments.libs.ormlite.field.FieldType;
import ru.easydonate.easypayments.libs.ormlite.field.SqlType;
import ru.easydonate.easypayments.libs.ormlite.field.types.BooleanType;
import ru.easydonate.easypayments.libs.ormlite.support.DatabaseResults;

public class BooleanCharType
extends BooleanType {
    private static final String DEFAULT_TRUE_FALSE_FORMAT = "10";
    private static final BooleanCharType singleTon = new BooleanCharType();

    public static BooleanCharType getSingleton() {
        return singleTon;
    }

    public BooleanCharType() {
        super(SqlType.CHAR);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) {
        return this.javaToSqlArg(fieldType, Boolean.parseBoolean(defaultStr));
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object obj) {
        String format = (String)fieldType.getDataTypeConfigObj();
        if (format == null || format.length() < 2) {
            format = DEFAULT_TRUE_FALSE_FORMAT;
        }
        return Character.valueOf((Boolean)obj != false ? format.charAt(0) : format.charAt(1));
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return Character.valueOf(results.getChar(columnPos));
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) {
        String format = (String)fieldType.getDataTypeConfigObj();
        if (format == null || format.length() < 2) {
            format = DEFAULT_TRUE_FALSE_FORMAT;
        }
        return ((Character)sqlArg).charValue() == format.charAt(0) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) {
        if (stringValue.length() == 0) {
            return Boolean.FALSE;
        }
        return this.sqlArgToJava(fieldType, Character.valueOf(stringValue.charAt(0)), columnPos);
    }

    @Override
    public Object makeConfigObject(FieldType fieldType) throws SQLException {
        String format = fieldType.getFormat();
        if (format == null) {
            return DEFAULT_TRUE_FALSE_FORMAT;
        }
        if (format.length() == 2 && format.charAt(0) != format.charAt(1)) {
            return format;
        }
        throw new SQLException("Invalid boolean format must have 2 different characters that represent true/false like \"10\" or \"tf\": " + format);
    }
}

