/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.util;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public final class Wrapper {
    @NotNull
    public static <T> Optional<T> wrapNullable(T object) {
        return Optional.ofNullable(object);
    }

    @NotNull
    public static <T> Optional<T> wrapNullable(T object, Predicate<T> condition) {
        return object != null && condition.test(object) ? Optional.of(object) : Optional.empty();
    }

    @NotNull
    public static Optional<String> wrapNullableOrEmpty(String object) {
        return Wrapper.wrapNullable(object, string -> !string.isEmpty());
    }

    @NotNull
    public static OptionalInt wrapNullableInt(Integer object) {
        return object != null ? OptionalInt.of(object) : OptionalInt.empty();
    }

    @NotNull
    public static OptionalInt wrapNullableInt(Integer object, IntPredicate condition) {
        return object != null && condition.test(object) ? OptionalInt.of(object) : OptionalInt.empty();
    }

    @NotNull
    public static OptionalLong wrapNullableLong(Long object) {
        return object != null ? OptionalLong.of(object) : OptionalLong.empty();
    }

    @NotNull
    public static OptionalLong wrapNullableLong(Long object, LongPredicate condition) {
        return object != null && condition.test(object) ? OptionalLong.of(object) : OptionalLong.empty();
    }

    @NotNull
    public static OptionalDouble wrapNullableDouble(Double object) {
        return object != null ? OptionalDouble.of(object) : OptionalDouble.empty();
    }

    @NotNull
    public static OptionalDouble wrapNullableDouble(Double object, DoublePredicate condition) {
        return object != null && condition.test(object) ? OptionalDouble.of(object) : OptionalDouble.empty();
    }
}

