/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.module;

import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.libs.easydonate4j.http.client.HttpClientService;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.JsonSerializationService;
import ru.easydonate.easypayments.libs.easydonate4j.module.ModuleNotRegisteredException;
import ru.easydonate.easypayments.libs.easydonate4j.module.ModuleType;

public final class ModuleRegistrator {
    private static final ModuleRegistrator INSTANCE = new ModuleRegistrator();
    private HttpClientService httpClientService;
    private JsonSerializationService jsonSerializationService;

    @NotNull
    public static ModuleRegistrator get() {
        return INSTANCE;
    }

    @NotNull
    public static HttpClientService httpClientService() throws ModuleNotRegisteredException {
        return INSTANCE.getHttpClientService();
    }

    @NotNull
    public static JsonSerializationService jsonSerializationService() throws ModuleNotRegisteredException {
        return INSTANCE.getJsonSerializationService();
    }

    public static boolean httpClientServiceRegistered(Class<? extends HttpClientService> serviceClass) {
        return INSTANCE.isHttpClientServiceRegistered() && ModuleRegistrator.httpClientService().getClass() == serviceClass;
    }

    public static boolean jsonSerializationServiceRegistered(Class<? extends JsonSerializationService> serviceClass) {
        return INSTANCE.isJsonSerializationServiceRegistered() && ModuleRegistrator.jsonSerializationService().getClass() == serviceClass;
    }

    @NotNull
    public HttpClientService getHttpClientService() throws ModuleNotRegisteredException {
        if (!this.isHttpClientServiceRegistered()) {
            throw new ModuleNotRegisteredException(ModuleType.HTTP_CLIENT_SERVICE);
        }
        return this.httpClientService;
    }

    @NotNull
    public JsonSerializationService getJsonSerializationService() throws ModuleNotRegisteredException {
        if (!this.isJsonSerializationServiceRegistered()) {
            throw new ModuleNotRegisteredException(ModuleType.JSON_SERIALIZATION_SERVICE);
        }
        return this.jsonSerializationService;
    }

    public void registerHttpClientService(@NotNull HttpClientService httpClientService) {
        this.httpClientService = httpClientService;
    }

    public void registerJsonSerializationService(@NotNull JsonSerializationService jsonSerializationService) {
        this.jsonSerializationService = jsonSerializationService;
    }

    public boolean isHttpClientServiceRegistered() {
        return this.httpClientService != null;
    }

    public boolean isJsonSerializationServiceRegistered() {
        return this.jsonSerializationService != null;
    }

    @NotNull
    public String toString() {
        return "ModuleRegistrator{httpClient=" + this.httpClientService + ", jsonSerialization=" + this.jsonSerializationService + '}';
    }
}

