/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.json.serialization.deserializer.gson;

import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.libs.easydonate4j.Constants;
import ru.easydonate.easypayments.libs.gson.JsonDeserializationContext;
import ru.easydonate.easypayments.libs.gson.JsonDeserializer;
import ru.easydonate.easypayments.libs.gson.JsonElement;
import ru.easydonate.easypayments.libs.gson.JsonNull;
import ru.easydonate.easypayments.libs.gson.JsonParseException;
import ru.easydonate.easypayments.libs.gson.JsonSerializationContext;
import ru.easydonate.easypayments.libs.gson.JsonSerializer;

public final class LocalDateTimeAdapter
implements JsonSerializer<LocalDateTime>,
JsonDeserializer<LocalDateTime> {
    private static final LocalDateTimeAdapter SINGLETON = new LocalDateTimeAdapter();

    @NotNull
    public static LocalDateTimeAdapter getSingleton() {
        return SINGLETON;
    }

    @Override
    @NotNull
    public JsonElement serialize(@Nullable LocalDateTime value, @NotNull Type type, @NotNull JsonSerializationContext context) {
        return value != null ? context.serialize(value.format(Constants.DATE_FORMATTER)) : JsonNull.INSTANCE;
    }

    @Override
    @Nullable
    public LocalDateTime deserialize(@Nullable JsonElement json, @NotNull Type type, @NotNull JsonDeserializationContext context) throws JsonParseException {
        if (json == null || json.isJsonNull()) {
            return null;
        }
        String valueAsString = json.getAsString();
        if (valueAsString == null || valueAsString.isEmpty()) {
            return null;
        }
        TemporalAccessor accessor = Constants.DATE_FORMATTER.parse(valueAsString);
        return LocalDateTime.from(accessor);
    }
}

