/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.json.serialization.deserializer.gson;

import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.libs.gson.JsonDeserializationContext;
import ru.easydonate.easypayments.libs.gson.JsonDeserializer;
import ru.easydonate.easypayments.libs.gson.JsonElement;
import ru.easydonate.easypayments.libs.gson.JsonParseException;

public final class BooleanIntDeserializer
implements JsonDeserializer<Boolean> {
    private static final BooleanIntDeserializer SINGLETON = new BooleanIntDeserializer();

    @NotNull
    public static BooleanIntDeserializer getSingleton() {
        return SINGLETON;
    }

    @Override
    @Nullable
    public Boolean deserialize(@Nullable JsonElement json, @NotNull Type type, @NotNull JsonDeserializationContext context) throws JsonParseException {
        if (json == null || !json.isJsonPrimitive()) {
            return null;
        }
        try {
            int valueAsInt = json.getAsInt();
            switch (valueAsInt) {
                case 0: {
                    return Boolean.FALSE;
                }
                case 1: {
                    return Boolean.TRUE;
                }
            }
        }
        catch (ClassCastException | NumberFormatException runtimeException) {
            // empty catch block
        }
        return json.getAsBoolean();
    }
}

