/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.json.serialization;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.GsonTypeAdapter;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.JsonSerializationService;
import ru.easydonate.easypayments.libs.gson.Gson;
import ru.easydonate.easypayments.libs.gson.TypeAdapter;
import ru.easydonate.easypayments.libs.gson.TypeAdapterFactory;
import ru.easydonate.easypayments.libs.gson.reflect.TypeToken;

public final class GsonTypeAdapterResolver
implements TypeAdapterFactory {
    private final JsonSerializationService jsonSerializationService;
    private final Map<Class<?>, GsonTypeAdapter<?>> typeAdapterCache;

    public GsonTypeAdapterResolver(@NotNull JsonSerializationService jsonSerializationService) {
        this.jsonSerializationService = jsonSerializationService;
        this.typeAdapterCache = new HashMap();
    }

    @Override
    @Nullable
    public synchronized <T> TypeAdapter<T> create(@NotNull Gson gson, @NotNull TypeToken<T> typeToken) {
        Class<T> type = typeToken.getRawType();
        Class<T> foundClass = this.jsonSerializationService.findRegisteredImplementation(type);
        if (foundClass == type) {
            return null;
        }
        if (foundClass.isInterface()) {
            throw new IllegalArgumentException(String.format("Cannot find a registered implementation for the %s!", type.getName()));
        }
        GsonTypeAdapter<Object> adapter = this.typeAdapterCache.get(foundClass);
        if (adapter == null) {
            adapter = new GsonTypeAdapter<T>(gson, foundClass);
            this.typeAdapterCache.put(foundClass, adapter);
        }
        return adapter;
    }
}

