/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.json.serialization;

import java.lang.reflect.Type;
import java.time.LocalDateTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.libs.easydonate4j.exception.JsonSerializationException;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.AbstractJsonSerializationService;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.GsonTypeAdapterResolver;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.JsonSerializationServiceType;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.deserializer.gson.BooleanIntDeserializer;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.deserializer.gson.LocalDateTimeAdapter;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.exclusion.GsonDeserializationExclusionStrategy;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.exclusion.GsonSerializationExclusionStrategy;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.failsafe.gson.ApiV3FailsafeModule;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.failsafe.gson.CallbackApiFailsafeModule;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.implementation.registry.JsonModelsGroup;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.implementation.registry.gson.ApiV3ModelsRegistry;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.implementation.registry.gson.CallbackApiModelsRegistry;
import ru.easydonate.easypayments.libs.easydonate4j.module.ModuleAlreadyRegisteredException;
import ru.easydonate.easypayments.libs.easydonate4j.module.ModuleRegistrator;
import ru.easydonate.easypayments.libs.easydonate4j.module.ModuleType;
import ru.easydonate.easypayments.libs.gson.Gson;
import ru.easydonate.easypayments.libs.gson.GsonBuilder;
import ru.easydonate.easypayments.libs.gson.JsonParseException;
import ru.easydonate.easypayments.libs.gson.TypeAdapterFactory;

public final class GsonSerializationService
extends AbstractJsonSerializationService {
    private final GsonBuilder defaultGsonBuilder;
    private final GsonBuilder prettyGsonBuilder;
    private final Gson unsafeGsonInstance;
    private Gson defaultGson;
    private Gson prettyGson;

    public GsonSerializationService() {
        GsonTypeAdapterResolver typeAdapterFactory = new GsonTypeAdapterResolver(this);
        this.defaultGsonBuilder = this.createGsonBuilder(typeAdapterFactory);
        this.prettyGsonBuilder = this.createGsonBuilder(typeAdapterFactory).setPrettyPrinting();
        this.unsafeGsonInstance = this.createGsonBuilder(typeAdapterFactory).create();
        this.updateGsonInstances();
    }

    public static void register() throws ModuleAlreadyRegisteredException {
        if (GsonSerializationService.isRegistered()) {
            throw new ModuleAlreadyRegisteredException(ModuleType.JSON_SERIALIZATION_SERVICE);
        }
        ModuleRegistrator.get().registerJsonSerializationService(new GsonSerializationService());
    }

    public static void registerIfNotRegisteredYet() {
        if (!GsonSerializationService.isRegistered()) {
            ModuleRegistrator.get().registerJsonSerializationService(new GsonSerializationService());
        }
    }

    public static boolean isRegistered() {
        return ModuleRegistrator.jsonSerializationServiceRegistered(GsonSerializationService.class);
    }

    @Override
    @NotNull
    public JsonSerializationServiceType getType() {
        return JsonSerializationServiceType.GSON;
    }

    @Override
    public <T> void registerImplementationAliasesGroup(@NotNull JsonModelsGroup jsonModelsGroup) {
        switch (jsonModelsGroup) {
            case API_V3_MODELS: {
                this.registerModelsGroup(jsonModelsGroup, ApiV3ModelsRegistry.getSingleton());
                new ApiV3FailsafeModule(this.unsafeGsonInstance).register(this.defaultGsonBuilder, this.prettyGsonBuilder);
                this.updateGsonInstances();
                break;
            }
            case CALLBACK_API_MODELS: {
                this.registerModelsGroup(jsonModelsGroup, CallbackApiModelsRegistry.getSingleton());
                new CallbackApiFailsafeModule(this.unsafeGsonInstance).register(this.defaultGsonBuilder, this.prettyGsonBuilder);
                this.updateGsonInstances();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("An unexpected json models group received: %s!", new Object[]{jsonModelsGroup}));
            }
        }
    }

    @Override
    @Nullable
    public String serialize(@Nullable Object object) throws JsonSerializationException {
        try {
            return this.defaultGson.toJson(object);
        }
        catch (JsonParseException ex) {
            throw new JsonSerializationException(ex);
        }
    }

    @Override
    @Nullable
    public <T> T deserialize(@NotNull Class<T> type, @Nullable String rawJson) throws JsonSerializationException {
        try {
            return this.defaultGson.fromJson(rawJson, type);
        }
        catch (JsonParseException ex) {
            throw new JsonSerializationException(ex);
        }
    }

    @Override
    @NotNull
    public String toPrettyString(@NotNull Object object) throws JsonSerializationException {
        try {
            return this.prettyGson.toJson(object);
        }
        catch (JsonParseException ex) {
            throw new JsonSerializationException(ex);
        }
    }

    private void updateGsonInstances() {
        this.defaultGson = this.defaultGsonBuilder.create();
        this.prettyGson = this.prettyGsonBuilder.create();
    }

    @NotNull
    private GsonBuilder createGsonBuilder(@NotNull TypeAdapterFactory typeAdapterFactory) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.serializeNulls();
        gsonBuilder.disableHtmlEscaping();
        gsonBuilder.addSerializationExclusionStrategy(GsonSerializationExclusionStrategy.getSingleton());
        gsonBuilder.addDeserializationExclusionStrategy(GsonDeserializationExclusionStrategy.getSingleton());
        gsonBuilder.registerTypeAdapter(Boolean.TYPE, BooleanIntDeserializer.getSingleton());
        gsonBuilder.registerTypeAdapter((Type)((Object)LocalDateTime.class), LocalDateTimeAdapter.getSingleton());
        gsonBuilder.registerTypeAdapterFactory(typeAdapterFactory);
        return gsonBuilder;
    }
}

