/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.json.serialization;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.Implementing;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.JsonSerializationService;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.implementation.registry.JsonModelsGroup;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.implementation.registry.JsonModelsRegistry;

public abstract class AbstractJsonSerializationService
implements JsonSerializationService {
    protected final Map<Class<?>, Class<?>> implementationAliases = new LinkedHashMap();
    protected final Map<JsonModelsGroup, JsonModelsRegistry> registeredModelsGroups = new LinkedHashMap<JsonModelsGroup, JsonModelsRegistry>();

    protected final void registerModelsGroup(@NotNull JsonModelsGroup group, @NotNull JsonModelsRegistry registry) {
        if (this.registeredModelsGroups.containsKey((Object)group)) {
            return;
        }
        this.registeredModelsGroups.put(group, registry);
        registry.register();
    }

    @NotNull
    public <T> Class<T> findRegisteredImplementation(@NotNull Class<T> type) {
        try {
            return this.implementationAliases.getOrDefault(type, type);
        }
        catch (ClassCastException ignored) {
            return type;
        }
    }

    @Override
    public <T> void registerImplementationAlias(@NotNull Class<T> interfaceType, @NotNull Class<? extends T> implementationType) {
        this.implementationAliases.put(interfaceType, implementationType);
    }

    @Override
    public <T> void registerImplementationAlias(@NotNull Class<? extends T> implementationType) {
        Implementing implementing = implementationType.getAnnotation(Implementing.class);
        if (implementing == null) {
            throw new IllegalArgumentException(String.format("'%s' must be annotated with @Implementing!", implementationType));
        }
        Class<?> interfaceType = implementing.value();
        if (interfaceType == null) {
            throw new IllegalArgumentException(String.format("'%s' is annotated with @Implementing, but implemented class is not specified!", implementationType));
        }
        try {
            this.registerImplementationAlias(interfaceType, implementationType);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(String.format("The '%s' doesn't implement the '%s', class cast failed!", implementationType, interfaceType));
        }
    }
}

