/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.http.client;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpRequestException;
import ru.easydonate.easypayments.libs.easydonate4j.http.request.EasyHttpRequest;
import ru.easydonate.easypayments.libs.easydonate4j.http.response.EasyHttpResponse;

public interface HttpClient {
    @NotNull
    public Optional<String> getApiEndpoint();

    @NotNull
    public String getUserAgent();

    @NotNull
    public Timeouts getTimeouts();

    @NotNull
    public EasyHttpRequest.Builder createRequest(@NotNull Method var1);

    @NotNull
    public EasyHttpResponse execute(@NotNull EasyHttpRequest var1) throws HttpRequestException;

    @NotNull
    public CompletableFuture<EasyHttpResponse> executeAsync(@NotNull EasyHttpRequest var1) throws HttpRequestException;

    public static enum Method {
        GET("GET", false),
        POST("POST", true);

        private final String name;
        private final boolean hasBody;

        public String getName() {
            return this.name;
        }

        public boolean isHasBody() {
            return this.hasBody;
        }

        private Method(String name, boolean hasBody) {
            this.name = name;
            this.hasBody = hasBody;
        }
    }

    public static interface Timeouts {
        public long getConnectTimeout();

        public long getResponseTimeout();

        public long getReadTimeout();

        public long getWriteTimeout();
    }

    public static interface Builder {
        @NotNull
        public HttpClient create();

        @NotNull
        public Builder setApiEndpoint(@NotNull String var1);

        @NotNull
        public Builder setConnectTimeout(long var1);

        @NotNull
        public Builder setResponseTimeout(long var1);

        @NotNull
        public Builder setReadTimeout(long var1);

        @NotNull
        public Builder setWriteTimeout(long var1);

        @NotNull
        public Builder setUserAgent(@NotNull String var1);
    }
}

