/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.http.client;

import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.libs.easydonate4j.http.client.HttpClient;
import ru.easydonate.easypayments.libs.easydonate4j.util.Validate;

public abstract class AbstractHttpClientBuilder
implements HttpClient.Builder {
    protected String apiEndpoint = null;
    protected String userAgent = "EasyDonate4J";
    protected long connectTimeout = 5000L;
    protected long responseTimeout = 5000L;
    protected long readTimeout = 5000L;
    protected long writeTimeout = 5000L;

    @Override
    @NotNull
    public HttpClient.Builder setApiEndpoint(@NotNull String apiEndpoint) {
        Validate.notEmpty(apiEndpoint, "apiEndpoint");
        this.apiEndpoint = apiEndpoint;
        return this;
    }

    @Override
    @NotNull
    public HttpClient.Builder setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Override
    @NotNull
    public HttpClient.Builder setResponseTimeout(long responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    @Override
    @NotNull
    public HttpClient.Builder setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @Override
    @NotNull
    public HttpClient.Builder setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    @Override
    @NotNull
    public HttpClient.Builder setUserAgent(@NotNull String userAgent) {
        Validate.notEmpty(userAgent, "userAgent");
        this.userAgent = userAgent;
        return this;
    }
}

